package team.bangbang.common.queue.rabbit.pool;

import java.io.IOException;
import java.util.concurrent.TimeoutException;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

import team.bangbang.common.config.Config;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;

/**
 * RabbitMQ连接池
 *
 * @author 帮帮组
 * @version 1.0 2018-9-30
 */
public final class RabbitPoolFactory implements PooledObjectFactory<Connection> {
    /* 日志 */
    // private static Logger logger = Logger.get
    /* 连接工厂 */
    private static ConnectionFactory factory = new ConnectionFactory();

    static {
        String uri = Config.getProperty("mq.rabbitmq.uri");

        try {
            factory.setUri(uri);
        } catch (Exception e) {
            e.getStackTrace();
        }
    }

    /**
     * 创建一个新的池对象
     *
     * @return 一个新的池对象
     */
    public PooledObject<Connection> makeObject() {
        Connection conn = null;
        try {
            conn = factory.newConnection();
            return new DefaultPooledObject<Connection>(conn);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TimeoutException e) {
            e.printStackTrace();
        }

        return null;
    }

    /**
     * 销毁池对象
     *
     * @param pooledObject 池对象
     */
    public void destroyObject(PooledObject<Connection> pooledObject) {
        Connection conn = pooledObject.getObject();
        try {
            conn.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 验证池对象是否有效
     *
     * @param pooledObject 池对象
     * @return 是否有效
     */
    public boolean validateObject(PooledObject<Connection> pooledObject) {
        Connection conn = pooledObject.getObject();
        boolean bl = conn.isOpen();
        System.out.println(bl);
        return bl;
    }

    /**
     * 激活池对象
     *
     * @param pooledObject 池对象
     */
    public void activateObject(PooledObject<Connection> pooledObject) {
        // Rabbit连接不能激活
        return;
    }

    /**
     * 钝化池对象，清除旧数据
     *
     * @param pooledObject 池对象
     */
    public void passivateObject(PooledObject<Connection> pooledObject) throws Exception {
        // Rabbit连接无就数据需要清除
        return;
    }
}
