package team.bangbang.common.service.agent;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;

import team.bangbang.common.config.Config;
import team.bangbang.common.net.http.HttpClient;
import team.bangbang.common.service.agent.RequestTransform;
import team.bangbang.common.service.agent.ResponseTransform;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import team.bangbang.common.service.agent.data.Forward;
import team.bangbang.common.service.agent.data.RestfulAgent;

/**
 * Restful服务代理 - 调用
 *
 * @author 帮帮组
 * @version 1.0  2019-09-28
 */
public class AgentInvoker {
	/* HTTP请求对象 */
	private static HttpClient hc = new HttpClient();
	/* 日志对象 */
	private static final Log log = LogFactory.getLog(AgentInvoker.class);
	/* Restful服务代理配置 */
	private RestfulAgent restfulAgent = null;
	/* 请求数据 */
	private Map<String, String> requestData = null;

	/**
	 * 构造一个Restful服务代理的调用对象
	 *
	 * @param restfulAgent Restful服务代理设置
	 */
	public AgentInvoker(RestfulAgent restfulAgent) {
		this.restfulAgent = restfulAgent;
	}

	/**
	 * 设置请求数据
	 * @param requestData 请求数据
	 */
	public void setRequestData(Map<String, String> requestData) {
		this.requestData = requestData;
	}

	/**
	 * 通过Restful服务代理调用Restful服务，并将返回值封装为Restful服务代理设置的返回格式
	 * @return Restful服务返回值
	 * @throws Exception 异常
	 */
	public JSONObject invoke() throws Exception {
		// 1. 请求参数转换
		RequestTransform rt = new RequestTransform();
		rt.setFromData(requestData);
		log.info("1. 原始请求参数 ======================================= ");
		log.info(JSON.toJSONString(requestData));

		// 2. 转换后的请求参数
		Map<String, String> rd2 = rt.getToData(restfulAgent);
		log.info("2. 转换后的请求参数 ==================================== ");
		log.info(JSON.toJSONString(rd2));

		Forward f = restfulAgent.getForward();
		// 请求方法
		String method = f.getMethod();
		String url = getUrl(f.getUrl());

		// 3. 返回值
		JSONObject ret = null;
		if("GET".equalsIgnoreCase(method)) {
			if(url.indexOf("?") < 0) {
				url += "?";
			} else {
				url += "&";
			}
			ret = hc.get(url + makeQueryString(rd2)).toJSONObject();
		} else {
			// POST方法调用
			ret = hc.post(url, rd2).toJSONObject();
		}

		log.info("3. 请求返回值 ========= =============================== ");
		log.info(ret);

		// 4. 返回值变换
		ResponseTransform rtt = new ResponseTransform();
		rtt.setFromData(ret);
		JSONObject ret2 = rtt.getToData(restfulAgent);

		log.info("4. 返回值变换 ======================================== ");
		log.info(ret2);

		return ret2;
	}

	/**
	 * 将地址中的变量替换为配置文件中的变量
	 * @param url 地址
	 * @return 替换变量后的地址
	 */
	private String getUrl(String url) {
		if(url == null) return url;
		url = url.replaceAll("\\s+", "");
		int n1 = 0;
		while((n1 = url.indexOf("${")) >= 0) {
			int n2 = url.indexOf("}", n1);
			if(n2 > n1) {
				String key = url.substring(n1 + 2, n2);
				String value = Config.getProperty(key);
				url = url.substring(0, n1) + value + url.substring(n2 + 1);
			} else {
				return url;
			}
		}

		return url;
	}

	/**
	 * 按照字典排序构造queryString，空值会被忽略
	 *
	 * @param data 传递的参数
	 * @return queryString
	 */
	private static String makeQueryString(Map<String, String> data) {
		// TreeMap的KEY按照字典排序
		Map<String, String> treeData = new TreeMap<String, String>();
		for (String key : data.keySet()) {
			Object value = data.get(key);
			if (value == null || !(value instanceof String)) {
				continue;
			}

			// 对value值进行去除前后空处理
			treeData.put(key, (String)value);
		}

		// 使用URL键值对的格式（即key1=value1&key2=value2…）拼接
		StringBuffer sb = new StringBuffer();
		Iterator<Map.Entry<String, String>> it = treeData.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry<String, String> entry = it.next();
			String key = entry.getKey();
			String value = entry.getValue();
			if (value == null || value.length() == 0) {
				continue;
			}
			if (sb.length() > 0) {
				sb.append("&");
			}
			sb.append(key + "=" + value);
		}

		return sb.toString();
	}

	/**
	 * 读取HTTP请求中的参数
	 *
	 * @param request HTTP请求
	 * @return HTTP请求中的参数
	 */
	public static Map<String, String> getRequestParameters(HttpServletRequest request) {
		Map<String, String> map = new HashMap<String, String>();

		Enumeration<String> er = request.getParameterNames();
		while(er != null && er.hasMoreElements()) {
			String key = er.nextElement();
			String value = request.getParameter(key);
			map.put(key, value);
		}

		return map;
	}
}
