package team.bangbang.common.service.agent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import team.bangbang.common.service.agent.data.Request;
import team.bangbang.common.service.agent.data.RequestParam;
import team.bangbang.common.service.agent.data.RestfulAgent;

/**
 * Restful服务代理 - 请求参数的转换
 *
 * @author 帮帮组
 * @version 1.0  2019-09-28
 */
public class RequestTransform {
	/* 源参数 */
	private Map<String, String> fromData = null;

	/**
	 * 设置源参数
	 * @param fromData 源参数
	 */
	public void setFromData(Map<String, String> fromData) {
		this.fromData = fromData;
	}

	/**
	 * 按照Restful服务代理配置获得目标参数
	 *
	 * @param ra Restful服务代理配置
	 * @return 目标参数
	 */
	public Map<String, String> getToData(RestfulAgent ra) {
		if(ra == null || ra.getRequest() == null ||
				ra.getRequest().getParams() == null) return null;
		Request req = ra.getRequest();
		List<RequestParam> rps = req.getParams();

		Map<String, String> toData = new HashMap<String, String>();

		for(RequestParam rp : rps) {
			String from = rp.getFrom();
			if(from == null || from.trim().length() == 0) continue;
			from = from.trim();

			String value = null;
			// 是否是固定值
			if(from.startsWith("$")) {
				value = from.substring(1);
			} else {
				value = fromData.get(from);
			}

			if(value == null) continue;

			toData.put(rp.getTo(), value);
		}

		return toData;
	}
}
