package team.bangbang.common.service.agent;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import team.bangbang.common.file.ResourceLoader;
import team.bangbang.common.file.XMLParser;
import org.jdom.Element;

import team.bangbang.common.service.agent.data.Forward;
import team.bangbang.common.service.agent.data.Request;
import team.bangbang.common.service.agent.data.RequestParam;
import team.bangbang.common.service.agent.data.Response;
import team.bangbang.common.service.agent.data.ResponseList;
import team.bangbang.common.service.agent.data.ResponseResult;
import team.bangbang.common.service.agent.data.RestfulAgent;
import team.bangbang.common.service.agent.data.RestfulAgents;

/**
 * Restful服务代理 - XML加载
 *
 * @author 帮帮组
 * @version 1.0  2019-09-28
 */
public class XmlLoader {

	/**
	 * 加载XML，形成RestfulAgents对象
	 *
	 * @param clazz          调用者的类型
	 * @param resourceFile 资源配置文件
	 * @return RestfulAgents对象
	 */
	public static RestfulAgents load(Class<?> clazz, String resourceFile) {
		InputStream is = null;
		try {
			is = ResourceLoader.getInputStream(clazz, resourceFile);

			XMLParser xp = new XMLParser(is);
			Element root = xp.getRootElement();

			RestfulAgents ras = new RestfulAgents();
			List<Element> agents = XMLParser.getChildren(root, "agent");
			for(int i = 0; agents != null && i < agents.size(); i++) {
				Element agent = agents.get(i);

				RestfulAgent ra = toRestfulAgent(agent);
				if(ra == null) continue;

				ras.getAgents().add(ra);
			}

			return ras;
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			if(is != null) {
				try {
					is.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

		return null;
	}

	/**
	 * 解析 agent 标签
	 * @param agent 标签元素
	 * @return RestfulAgent对象
	 */
	private static RestfulAgent toRestfulAgent(Element agent) {
		if(agent == null) return null;
		RestfulAgent ra = new RestfulAgent();

		// 1. name
		ra.setName(agent.getChildText("name"));
		// 2. forward
		Forward forward = new Forward();
		Element ele2 = agent.getChild("forward");
		// forward - url
		forward.setUrl(ele2.getAttributeValue("url"));
		forward.setMethod(ele2.getAttributeValue("method"));
		if(forward.getMethod() == null) {
			forward.setMethod(Forward.DefaultMethod);
		}
		ra.setForward(forward);

		// 3. request
		Element ele3 = agent.getChild("request");
		Request request = toRequest(ele3);
		ra.setRequest(request);

		// 4. response
		Element ele4 = agent.getChild("response");
		Response response = toResponse(ele4);
		ra.setResponse(response);

		return ra;
	}

	/**
	 * 解析 request 标签
	 * @param ele request标签元素
	 * @return Request对象
	 */
	private static Request toRequest(Element ele) {
		if(ele == null) return null;

		// from="form" to="json"
		Request req = new Request();
		req.setFrom(ele.getAttributeValue("from"));
		req.setTo(ele.getAttributeValue("to"));
		// param标签
		List<Element> eles = XMLParser.getChildren(ele, "param");
		for(int i = 0; eles != null && i < eles.size(); i++) {
			Element ep = eles.get(i);
			// <param from="reqTime" to="user.startTime"/>
			RequestParam rp = new RequestParam();
			rp.setFrom(ep.getAttributeValue("from"));
			rp.setTo(ep.getAttributeValue("to"));

			req.getParams().add(rp);
		}

		return req;
	}

	/**
	 * 解析 response 标签
	 * @param ele response标签元素
	 * @return Response对象
	 */
	private static Response toResponse(Element ele) {
		if(ele == null) return null;

		Response resp = new Response();

		// result标签
		List<Element> eles = XMLParser.getChildren(ele, "result");
		for(int i = 0; eles != null && i < eles.size(); i++) {
			Element ep = eles.get(i);
			// <result from="statusCode" to="resCode" format="yyyy-MM-dd" default="">
			ResponseResult rr = new ResponseResult();
			rr.setFrom(ep.getAttributeValue("from"));
			rr.setTo(ep.getAttributeValue("to"));
			rr.setFormat(ep.getAttributeValue("format"));
			rr.setDefaultValue(ep.getAttributeValue("default"));

			// 是否有map对象
			List<Element> eleMap = XMLParser.getChildren(ep, "map");
			for(int j = 0; eleMap != null && j < eleMap.size(); j++) {
				Element epj = eleMap.get(j);
				// <map value="100" to="000000"/>
				String value = epj.getAttributeValue("value");
				String to = epj.getAttributeValue("to");
				rr.getMap().put(value, to);
			}

			resp.getResults().add(rr);
		}

		// list标签
		eles = XMLParser.getChildren(ele, "list");
		for(int i = 0; eles != null && i < eles.size(); i++) {
			Element ep = eles.get(i);
			// <list from="list" to="resultList">
			ResponseList rl = new ResponseList();
			rl.setFrom(ep.getAttributeValue("from"));
			rl.setTo(ep.getAttributeValue("to"));
			// result对象
			List<Element> eleMap = XMLParser.getChildren(ep, "result");
			for(int j = 0; eleMap != null && j < eleMap.size(); j++) {
				Element epj = eleMap.get(j);
				ResponseResult rr = new ResponseResult();
				// <result from="100" to="000000" format="" default=""/>
				rr.setFrom(epj.getAttributeValue("from"));
				rr.setTo(epj.getAttributeValue("to"));
				rr.setFormat(epj.getAttributeValue("format"));
				rr.setDefaultValue(epj.getAttributeValue("default"));

				// 是否有map对象
				List<Element> eleMap2 = XMLParser.getChildren(ep, "map");
				for(int j2 = 0; eleMap2 != null && j2 < eleMap2.size(); j2++) {
					Element epj2 = eleMap2.get(j2);
					// <map value="100" to="000000"/>
					String value = epj2.getAttributeValue("value");
					String to = epj2.getAttributeValue("to");
					rr.getMap().put(value, to);
				}

				rl.getListResults().add(rr);
			}

			resp.getLists().add(rl);
		}

		return resp;
	}
}
