package team.bangbang.common.service.agent.data;

import java.util.HashMap;
import java.util.Map;

/**
 * Restful服务代理配置对象 - 响应数据 - 数据项
 *
 * @author 帮帮组
 * @version 1.0  2019-09-28
 */
public class ResponseResult {
	/* 原响应数据项名称，如果是json的话，用点号“.”表示层级关系 */
	private String from = null;
	/* 目标响应数据项名称，如果是json的话，用点号“.”表示层级关系 */
	private String to = null;
	/* 默认值 */
	private String defaultValue = null;
	/* 格式化，仅对日期类型有效 */
	private String format = null;
	/* 数据映射 */
	private Map<String, String> map = new HashMap<String, String>();

	/**
	 * @return 原响应数据项名称，如果是json的话，用点号“.”表示层级关系
	 */
	public String getFrom() {
		return from;
	}
	/**
	 * @param from 原响应数据项名称，如果是json的话，用点号“.”表示层级关系
	 */
	public void setFrom(String from) {
		this.from = from;
	}
	/**
	 * @return 目标响应数据项名称，如果是json的话，用点号“.”表示层级关系
	 */
	public String getTo() {
		return to;
	}
	/**
	 * @param to 目标响应数据项名称，如果是json的话，用点号“.”表示层级关系
	 */
	public void setTo(String to) {
		this.to = to;
	}

	/**
	 * @return 默认值
	 */
	public String getDefaultValue() {
		return defaultValue;
	}
	/**
	 * @param defaultValue 默认值
	 */
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	/**
	 * @return 格式化，仅对日期类型有效
	 */
	public String getFormat() {
		return format;
	}
	/**
	 * @param format 格式化，仅对日期类型有效
	 */
	public void setFormat(String format) {
		this.format = format;
	}
	/**
	 * @return 数据映射
	 */
	public Map<String, String> getMap() {
		return map;
	}
}
