package team.bangbang.common.service.agent.data;

import java.util.ArrayList;
import java.util.List;
/**
 * Restful服务代理配置对象
 *
 * @author 帮帮组
 * @version 1.0  2019-09-28
 */
public class RestfulAgents {
	/* 代理列表 */
	private List<RestfulAgent> agents = new ArrayList<RestfulAgent>();

	/**
	 * @return 代理列表
	 */
	public List<RestfulAgent> getAgents() {
		return agents;
	}

	/**
	 * 获得指定的代理
	 *
	 * @param name 代理名称
	 * @return 指定的代理
	 */
	public RestfulAgent getAgent(String name) {
		if(agents == null || agents.isEmpty() || name == null) {
			return null;
		}

		for (RestfulAgent ra : agents) {
			if(ra == null || ra.getName() == null) continue;

			if(ra.getName().trim().equals(name.trim())) {
				return ra;
			}
		}

		return null;
	}
}
