package team.bangbang.common.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import team.bangbang.common.utility.LogicUtility;

/**
 * 向客户端输出条形码、二维码。条形码支持[A-Z]大写字母、[0-9]数字
 *
 * http请求参数：<br>
 *
 * width: 宽度像素，默认为200px。
 * height：高度像素，默认为200px。
 * type：码类型，默认为qr，可选为qr、bar
 * value: 需要转变为条形码、二维码的字符串
 *
 * @author 帮帮组
 * @version 1.0 2013-06-18
 */
@WebServlet(urlPatterns = "/common/code")
public class CodeServlet extends HttpServlet {
	private static final long serialVersionUID = -8575660535779350577L;

	@Override
	protected void service(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		String s = request.getParameter("width");
		int width = (s != null ? LogicUtility.parseInt(s, 200) : 200);
		s = request.getParameter("height");
		int height = (s != null ? LogicUtility.parseInt(s, 200) : 200);

		String type = request.getParameter("type");
		if("bar".equalsIgnoreCase(type)) {
			type = "bar";
		} else {
			type = "qr";
		}

		// 字符串
		String value = request.getParameter("value");
		if (value == null) {
			return;
		}

		// 字符串的字符集
		Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
		hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
		hints.put(EncodeHintType.MARGIN, 1);

		MultiFormatWriter formatWriter = new MultiFormatWriter();
		// 按照指定的宽度，高度和附加参数对字符串进行编码
		BitMatrix bitMatrix = null;
		try {
			if(type.equals("qr")) {
				bitMatrix = formatWriter.encode(value, BarcodeFormat.QR_CODE,
						width, height, hints);
			} else {
				bitMatrix = formatWriter.encode(value, BarcodeFormat.CODE_128,
						width, height, hints);
			}

			MatrixToImageWriter.writeToStream(bitMatrix, "JPEG", response
					.getOutputStream());
		} catch (WriterException e) {
			e.printStackTrace();
		}
	}
}
