package team.bangbang.common.servlet;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import team.bangbang.common.config.Config;
import team.bangbang.common.exp.FileDownloader;
import team.bangbang.common.utility.LogicUtility;

//************************************************************************
//系统名称：帮帮WEB开发辅助类库
//class名称：文件下载

/**
 * 以二进制流的形式下在文件，下载的文件文件名由传入参数决定。传入参数为file。<br>
 * file为要下载的文件名称。下载文件的目录可以自定义配置，配置参数为application.properties中<br>
 * file.attachment.directory。 <br>
 *
 * 参数：<br>
 * <b>file</b>
 * 必选，指定下载的文件名称，可以包含部分路径，这部分参数与application.properties中{file.attachment.directory}目录
 * 组成完整的服务器端的文件路径<br>
 * <b>name</b> 可选，指定下载到客户端的文件名称，可以包含汉字，但必须是UTF-8字符集。如果不指定该参数，则默认使用服务器端的文件名称进行下载。
 *
 * @author 帮帮组
 * @version 1.0
 */
// ************************************************************************
@WebServlet(urlPatterns = "/common/download")
public class DownloadServlet extends HttpServlet {
	private static final long serialVersionUID = 5705266263138010543L;

	/**
	 * @param request
	 *            HTTP请求
	 * @param response
	 *            HTTP响应
	 */
	public void service(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		request.setCharacterEncoding("utf-8");
		response.setContentType("text/html;charset=utf-8");
		String strFile = request.getParameter("file");
		String strName = request.getParameter("name");

		try {
			strFile = URLDecoder.decode(strFile,"utf-8");
		} catch (Exception e) {
			System.out.println(e);
		}

		// strFile = URLDecoder.decode(strFile);
		//strFile = LogicUtility.getCNString(strFile);

		if (strName != null) {
			strName = LogicUtility.getCNString(strName);
		}

		// 修补漏洞，避免以下地址也可以下载
		// download?file=../../../../../../../../../../etc/shadow
		if (strFile != null && strFile.indexOf("../") >= 0) {
			return;
		}

		FileInputStream fis = null;
		OutputStream sos = null;
		try {
			// 下载前检查
			if (!beforeDownload(request, response)) {
				return;
			}

			String strPath = Config.getProperty("file.attachment.directory");
			// 下载文件名有效
			if (strFile != null && strFile.trim().length() > 0) {
				if (strPath != null) {
					strFile = strPath + "/" + strFile;
				}
				
				// 将本地的文件使用指定的文件名称下载到浏览器端
				FileDownloader.download(strFile, strName, request, response);

				afterDownload(request, response);
			}
		} catch (Exception ex) {
			// throw new IOException(ex.getMessage());
		} finally {
			try {
				fis.close();
			} catch (Exception exception1) {
			}
			try {
				sos.close();
			} catch (Exception exception2) {
			}
		}
	}

	/**
	 * 文件下载前检查，用于子类的扩展。
	 *
	 * @param request
	 *            HTTP请求
	 * @param response
	 *            HTTP响应
	 * @return 返回值为true时，表示允许下载；为false时表示阻止下载
	 */
	protected boolean beforeDownload(HttpServletRequest request,
									 HttpServletResponse response) {
		return true;
	}

	/**
	 * 处理文件下载后的事务，用于子类的扩展
	 *
	 * @param request
	 *            HTTP请求
	 * @param response
	 *            HTTP响应
	 */
	protected void afterDownload(HttpServletRequest request,
								 HttpServletResponse response) {
	}
}
