package team.bangbang.common.servlet;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import team.bangbang.common.utility.LogicUtility;

/**
 * 为请求地址追加参数
 *
 * <pre>
 * 	在一些Web服务场合，不允许出现带有参数的请求地址，用本Servlet将参数按照规则编排在请求地址的虚拟路径中。
 *
 *  本Servlet解析虚拟路径中的参数，然后转向到目标地址。
 *
 *  参数编排到虚拟路径中的规则：
 *  ../page.jsp/a--2345/b--fdfd/page.jsp.param
 *  转换为：
 *  ../page.jsp?a=2345&amp;b=fdfd
 *
 *  其中page.jsp.param，表名目标地址是page.jsp页面
 * </pre>
 *
 * @author 帮帮组
 * @version 1.0 2015-04-29
 */
@WebServlet(urlPatterns = "*.param")
public class ParameterServlet extends HttpServlet {
	private static final long serialVersionUID = 5115173158990832132L;

	@Override
	protected void service(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// 当前访问的地址（contextPath之后的字符串部分）
		String strURI = request.getRequestURI().trim()
				.substring(request.getContextPath().length());
		// 得到请求页面
		String page = getPage(strURI);
		if (page == null || page.trim().length() == 0) {
			response.getWriter().println("target page not found.");
			return;
		}

		// 得到虚拟路径中的参数
		String p1 = getParameters(strURI, page);
		// 此Servlet直接接收的参数
		StringBuffer sb = new StringBuffer();
		Enumeration<String> er = request.getParameterNames();
		while (er != null && er.hasMoreElements()) {
			String key = er.nextElement();
			String value = request.getParameter(key);
			if (sb.length() > 0) {
				sb.append("&");
			}
			sb.append(key).append("=").append(value);
		}
		String p2 = sb.toString();

		if(p1 == null) p1 = "";
		sb = new StringBuffer();
		sb.append(p1);
		if(p2.length() > 0) {
			if(sb.length() > 0) sb.append("&");
			sb.append(p2);

		}
		if(sb.length() > 0) {
			page += "?" + sb;
		}

		String context = request.getContextPath();
		if(context.length() > 1) {
			page = context + page;
		}

		response.sendRedirect(page);
	}

	private String getParameters(String s, String page) {
		// 掐头
		s = s.substring(page.length());
		// 去尾
		int n1 = s.lastIndexOf("/");
		if (n1 < 0) {
			return null;
		}

		s = s.substring(0, n1);
		// 以/为间隔符进行拆分
		String[] arr = LogicUtility.splitString(s, "/");

		StringBuffer sb = new StringBuffer();
		for (int i = 0; arr != null && i < arr.length; i++) {
			s = arr[i];
			// 以--为间隔符进行拆分
			n1 = s.indexOf("--");
			if (n1 <= 0) {
				continue;
			}

			if (sb.length() > 0) {
				sb.append("&");
			}

			sb.append(s.substring(0, n1)).append("=")
					.append(s.substring(n1 + 2));
		}

		return sb.toString();
	}

	private String getPage(String s) {
		int n1 = s.lastIndexOf("/");
		if (n1 < 0) {
			return null;
		}

		int n2 = s.lastIndexOf(".");
		if (n2 < 0 || n1 >= n2) {
			return null;
		}

		// 请求页面的名称
		String name = s.substring(n1 + 1, n2);
		s = s.substring(0, n1);
		n1 = s.lastIndexOf(name);
		if (n1 < 0) {
			return null;
		}

		return s.substring(0, n1) + name;
	}
}
