package team.bangbang.common.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import team.bangbang.common.config.Config;

/**
 * 使用二进制数据流的形式从服务器端取文件数据。所取的文件放置于配置目录下，配置信息在<br>
 * application.properties中，配置项为file.attachment.directory
 *
 * @author 帮帮组
 * @version 1.0  2006-11-30
 */
@WebServlet(urlPatterns = "/common/stream")
public class StreamServlet extends HttpServlet {
	private static final long serialVersionUID = -494536911233684044L;

	/**
	 * 根据传入的照片分类目录和照片文件名称取照片文件，并输出到服务器端
	 *
	 * @param request
	 *            页面请求对象
	 * @param response
	 *            页面响应对象
	 */
	public void service(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		request.setCharacterEncoding("utf-8");
		String file = request.getParameter("file");
		if (file == null)
			return;

		// 中文化处理
//		file = LogicUtility.getCNString(file);
		try {
			file = URLDecoder.decode(file,"utf-8");
		} catch (Exception e) {
			System.out.println(e);
		}

		// 获得照片的配置路径
		String path = Config.getProperty("file.attachment.directory");
		if (path == null)
			return;
		if (!path.endsWith("/") || !path.endsWith("\\")) {
			path += "/";
		}

		file = path + file;
		if(File.separatorChar == '\\') {
			file = file.replace('/', File.separatorChar);
		} else {
			file = file.replace('\\', File.separatorChar);
		}

		FileInputStream fis = null;
		OutputStream sos = null;

		try {
			// 以二进制流的形式传递文件
			fis = new FileInputStream(file);
			sos = response.getOutputStream();

			byte buff[] = new byte[512];
			int nLen = 0;
			while ((nLen = fis.read(buff)) > 0) {
				sos.write(buff, 0, nLen);
				sos.flush();
			}
		} catch (Exception e) {
		} finally {
			try {
				fis.close();
			} catch (Exception exception1) {
			}
			if (sos != null) {
				try {
					sos.close();
				} catch (Exception ex) {
				}
			} // end if
		}
	} // end service()
}
