package team.bangbang.common.sql;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

/**
 * Clob字段的读写，适用的数据库为Oracle
 *
 * @author 帮帮组
 * @version 1.0  2007-3-2
 */
public class ClobRW {
	/* Clob对象 */
	private Clob clob = null;

	/**
	 * 构造方法
	 *
	 * @param clob
	 *            Clob对象
	 */
	public ClobRW(Clob clob) {
		this.clob = clob;
	}

	/**
	 * 从Clob中读取大文本字符串内容
	 *
	 * @return 大文本内容
	 * @throws SQLException SQL异常
	 */
	public String read() throws SQLException {
		// 将CLOB类型的字段从数据库中读取出来放入到data传到页面中显示
		StringBuffer sb = new StringBuffer();
		BufferedReader read = null;
		try {
			Reader reader = clob.getCharacterStream();
			read = new BufferedReader(reader);

			char arr[] = new char[512];
			int nLen = read.read(arr);

			while (nLen > 0) {
				sb.append(arr, 0, nLen);
				nLen = read.read(arr);
			}
		} catch (Exception ex) {
		} finally {
			if (read != null) {
				try {
					read.close();
				} catch (Exception ex2) {
				}
			}
		}

		return sb.toString();
	}

	/**
	 * 向Clob中写入大文本内容
	 *
	 * @param content
	 *            大文本内容
	 * @throws SQLException SQL异常
	 */
	public void write(String content) throws SQLException {
		Writer out = null;
		try {
			// 从1位置开始
			out = clob.setCharacterStream(1L);
			out.write(content);
		} catch (Exception ex) {
		} finally {
			if (out != null) {
				try {
					out.close();
				} catch (Exception ex2) {
				}
			}
		} // end try
	}
}
