package team.bangbang.common.sql;

import java.util.List;

import team.bangbang.common.data.Pagination;
import team.bangbang.common.exception.BizException;

/**
 * 数据层操作对象
 *
 * @author 帮帮组
 * @version 1.0
 *
 * @param <T> DAO针对的业务实体类型
 */
public interface IDAO<T> {
	/**
	 * 查询单个POJO信息
	 *
	 * @param form
	 *            查询条件，具体类型为各模块的POJO类型
	 * @return 查询得到的POJO信息
	 * @throws BizException 业务异常
	 */
	public T getObject(T form) throws BizException;

	/**
	 * 查询单个POJO信息
	 *
	 * @param form
	 *            查询条件
	 * @param appendix
	 *            附加限定条件
	 * @return 查询得到的模板信息
	 * @throws BizException 业务异常
	 */
	public T getObject(T form, String appendix) throws BizException;

	/**
	 * 查询多个POJO信息
	 *
	 * @param form
	 *            查询条件，具体类型为各模块的POJO类型
	 * @param pa
	 *            分页信息，如果为null，表示不分页
	 *
	 * @return 查询得到的POJO信息列表
	 * @throws BizException 业务异常
	 */
	public List<T> list(T form, Pagination pa) throws BizException;

	/**
	 * 查询多个POJO信息
	 *
	 * @param form
	 *            查询条件
	 * @param appendix
	 *            附加限定条件
	 * @param pa
	 *            分页信息，如果为null，表示不分页
	 *
	 * @return 查询得到的POJO信息列表
	 * @throws BizException 业务异常
	 */
	public List<T> list(T form, String appendix, Pagination pa)
			throws BizException;

	/**
	 * 向数据库中插入一条POJO信息
	 *
	 * @param form
	 *            需要插入数据库的POJO信息
	 * @return 插入记录的条数
	 * @throws BizException 业务异常
	 */
	public int insert(T form) throws BizException;

	/**
	 * 根据限定条件修改POJO信息
	 *
	 * @param form
	 *            需要修改数据库的POJO信息，必须包含ID信息
	 *
	 * @return 修改记录的条数
	 * @throws BizException 业务异常
	 */
	public int update(T form) throws BizException;

	/**
	 * 根据限定条件修改POJO信息
	 *
	 * @param form
	 *            需要修改数据库的POJO信息
	 * @param condition
	 *            限定条件
	 * @return 修改记录的条数
	 * @throws BizException 业务异常
	 */
	public int update(T form, String condition) throws BizException;


	/**
	 * 根据限定条件删除POJO信息
	 *
	 * @param form
	 *            需要删除的POJO信息，必须包含ID信息
	 *
	 * @return 删除的记录条数
	 * @throws BizException 业务异常
	 */
	public int delete(T form) throws BizException;

	/**
	 * 根据限定条件删除POJO信息
	 *
	 * @param form
	 *            需要删除的POJO信息
	 * @param condition
	 *            限定条件
	 *
	 * @return 删除的记录条数
	 * @throws BizException 业务异常
	 */
	public int delete(T form, String condition) throws BizException;
}
