package team.bangbang.common.sql;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import team.bangbang.common.data.Pagination;

//************************************************************************
//系统名称：WEB开发基础平台类库
//class名称：MyBatis查询Mapper

/**
 * 所有Mapp的父接口
 *
 * @author 帮帮组
 * @version 1.0 2017-08-12
 *
 * @param <T> Mapper针对的业务实体类型
 */
public interface IMybatisMapper<T> {
    /**
     * 插入一条记录
     *
     * @param data 插入的数据，不能为null
     * @return 1：成功 其它：失败
     */
    int insert(@Param("data") T data);

    /**
     * 删除记录
     *
     * @param where    删除条件，不能为null
     * @param appendix 附加限定条件
     * @return 成功删除的记录数量
     */
    int delete(@Param("where") T where, @Param("appendix") Object appendix);

    /**
     * 查询一条记录，并转化为相应的POJO对象
     *
     * @param where    查询条件，不能为null
     * @param appendix 附加限定条件
     * @return 返回结果记录，并转化为相应的POJO对象
     */
    T getObject(@Param("where") T where, @Param("appendix") Object appendix);

    /**
     * 修改记录
     *
     * @param where    更新条件，不能为null
     * @param appendix 附加限定条件
     * @param data     更新数据，不能为null
     * @return 成功修改的记录数量
     */
    int update(@Param("where") T where, @Param("appendix") Object appendix, @Param("data") T data);

    /**
     * 查询多条记录，并转化为相应的POJO对象列表
     *
     * @param where      更新条件，不能为null
     * @param appendix   附加限定条件
     * @param pagination 分页参数，如果分页参数为空，表示不分页
     * @return 返回结果记录，并转化为相应的POJO对象列表
     */
    List<T> list(@Param("where") T where, @Param("appendix") Object appendix, @Param("pagination") Pagination pagination);

    /**
     * 获得符合条件的记录数量
     *
     * @param where    查询条件，不能为null
     * @param appendix 附加限定条件
     * @return 返回记录数量
     */
    int count(@Param("where") T where, @Param("appendix") Object appendix);
}
