package team.bangbang.common.sql.generator;

/**
 * 记录默认的数据库联接池的表名、关键字段名称、关键字段长度和下一个关键字的值。<br>
 * 假定一个数据库表只有一个关键字段，且该关键字段为字符类型
 *
 * @author 帮帮组
 * @version 1.0 2007-2-28
 */
public class TableKey {
	/* 数据库表名 */
	private String tableName = null;

	/* 关键字段名称 */
	private String keyName = null;

	/* 关键字段类型 */
	private String keyType = null;

	/* 关键字段的长度 */
	private int keyLength = 0;

	/* 关键字段的字符前缀 */
	private String prefix = "";

	/* 当前关键字段值的数字部分 */
	private long currentKeyNumber = 0;

	/**
	 * @param keyLength
	 *            关键字段的长度
	 */
	public void setKeyLength(int keyLength) {
		this.keyLength = keyLength;
	}

	/**
	 * @return 关键字段的类型
	 */
	public String getKeyType() {
		return keyType;
	}

	/**
	 * @return 关键字段的长度
	 */
	public int getKeyLength() {
		return keyLength;
	}

	/**
	 * @return 关键字段名称
	 */
	public String getKeyName() {
		return keyName;
	}

	/**
	 * @param keyName
	 *            关键字段名称
	 */
	public void setKeyName(String keyName) {
		this.keyName = keyName;
	}

	/**
	 * @return 数据库表名
	 */
	public String getTableName() {
		return tableName;
	}

	/**
	 * @param tableName
	 *            数据库表名
	 */
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	/**
	 * @param prefix
	 *            关键字段的字符前缀
	 */
	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	/**
	 * @return 关键字段的字符前缀
	 */
	public String getPrefix() {
		return prefix;
	}

	/**
	 * @param currentKeyNumber
	 *            当前关键字段值的数字部分
	 */
	public void setCurrentKeyNumber(long currentKeyNumber) {
		if (currentKeyNumber > this.currentKeyNumber) {
			this.currentKeyNumber = currentKeyNumber;
		}
	}

	/**
	 * 下一个关键字段的值，如果主键类型是字符型，则返回的字段值为字符型；<br>
	 * 否则视主键类型为整型，将当前记录中最大的主键值加1。
	 *
	 * @return 下一个关键字段的值
	 */
	public synchronized Object getNextKeyValue() {
		if (keyType.indexOf("CHAR") >= 0) {
			// 当前编号加1
			currentKeyNumber++;

			String strSeq = String.valueOf(currentKeyNumber);

			// 如果产生的PK值的长度大于字段的长度
			if (strSeq.length() > keyLength - prefix.length()) {
				return null;
			}

			// 拼接编号字符串
			while (strSeq.length() < keyLength - prefix.length())
				strSeq = "0" + strSeq;

			return prefix + strSeq;
		} else {
			// 主键类型为整型
			Object objValue = new Long(++currentKeyNumber);

			String strSeq = String.valueOf(objValue);

			// 如果产生的PK值的长度大于字段的长度
			if (strSeq.length() > keyLength) {
				return null;
			}

			return objValue;
		}
	}

	/**
	 * @param keyType
	 *            关键字段类型
	 */
	public void setKeyType(String keyType) {
		this.keyType = keyType;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((keyName == null) ? 0 : keyName.hashCode());
		result = PRIME * result
				+ ((tableName == null) ? 0 : tableName.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final TableKey other = (TableKey) obj;
		if (keyName == null) {
			if (other.keyName != null)
				return false;
		} else if (!keyName.equals(other.keyName))
			return false;
		if (tableName == null) {
			if (other.tableName != null)
				return false;
		} else if (!tableName.equals(other.tableName))
			return false;
		return true;
	}
}
