package team.bangbang.common.utility;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * 集合操作
 *
 * @author 帮帮组
 * @version 1.0  2019年5月31日
 */
public class SetUtility {

	/**
	 * 求补集，即从一个集合范围内删除一个集合范围内的元素
	 *
     * @param <T> 集合元素类型
	 * @param sourceIds 主集合范围
	 * @param removeIds 待删除的集合范围
	 * @return 补集删除后剩下的集合
	 */
	public static <T>Set<T> remove(Collection<T> sourceIds, Collection<T> removeIds) {
		// 剩下的集合
		Set<T> leftIds = new HashSet<T>();
		if (sourceIds == null || sourceIds.isEmpty()) {
			return leftIds;
		}

		for (T t : sourceIds) {
			if (t == null) continue;

			if (removeIds != null && removeIds.contains(t)) continue;

			leftIds.add(t);
		}

		return leftIds;
	}

	/**
	 * 取两个集合的交集
	 *
     * @param <T> 集合元素类型
	 * @param ids1 集合1
	 * @param ids2 集合2
	 * @return 两个集合的交集
	 */
	public static <T>Set<T> join(Collection<T> ids1, Collection<T> ids2) {
		// 相交集合
		Set<T> joinIds = new HashSet<T>();
		if (ids1 == null) {
			ids1 = Collections.emptySet();
		}
		if (ids2 == null) {
			ids2 = Collections.emptySet();
		}

		for (T t : ids1) {
			if (t == null) continue;
			if (ids2.contains(t)) {
				joinIds.add(t);
			}
		}

		return joinIds;
	}

	/**
	 * 取两个集合的合集
	 *
     * @param <T> 集合元素类型
	 * @param ids1 集合1
	 * @param ids2 集合2
	 * @return 两个集合的合集
	 */
	public static <T>Set<T> combine(Collection<T> ids1, Collection<T> ids2) {
		// 相交集合
		Set<T> comIds = new HashSet<T>();
		if (ids1 == null) {
			ids1 = Collections.emptySet();
		}
		if (ids2 == null) {
			ids2 = Collections.emptySet();
		}

		for (T t : ids1) {
			if (t == null) continue;
			comIds.add(t);
		}

		for (T t : ids2) {
			if (t == null || comIds.contains(t)) continue;
			comIds.add(t);
		}

		return comIds;
	}

	/**
	 * 将集合内的元素转变为指定的类型
	 *
     * @param <T> 目标集合元素类型
	 * @param ids 集合
	 * @param cls 对象类型
	 *
	 * @return 类型转变后的合集
	 */
	@SuppressWarnings("unchecked")
	public static <T>Set<T> toType(Collection<?> ids, Class<T> cls) {
		// 相交集合
		Set<T> resultIds = new HashSet<T>();
		if (ids == null) {
			return resultIds;
		}

		for (Object obj : ids) {
			if (obj == null) continue;
			resultIds.add((T)obj);
		}

		return resultIds;
	}
}
