package team.bangbang.common.utility;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 树，可以使用TreeUtil进行梳理。
 *
 * @author 帮帮组
 * @version 1.0  2006-07-14
 */
public class TreeNode implements Comparable<Object>, Serializable {
	private static final long serialVersionUID = 2897075438574946891L;
	/* 当前树顶节点编号 */
	private Object id = null;
	/* 父节点编号 */
	private Object parentId = null;
	/* 节点名称 */
	private String name = null;
	/* 序号 */
	private String orderBy = null;
	/* 有效标识 */
	private Boolean activeFlag = null;
	/* 子树 */
	private TreeNode sons[] = null;
	/* 属性 */
	private Map<Object, Object> attribute = new HashMap<Object, Object>();

	/**
	 * @param id 得到当前树顶节点的编号
	 */
	public void setId(Object id) {
		this.id = id;
	}

	/**
	 * @return 得到当前树顶节点的编号
	 */
	public Object getId() {
		return id;
	}

	/**
	 * @return 得到当前树父节点编号
	 */
	public Object getParentId() {
		return parentId;
	}

	/**
	 * @param parentId 得到当前树父节点编号
	 */
	public void setParentId(Object parentId) {
		this.parentId = parentId;
	}

	/**
	 * @return 节点名称
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name 节点名称
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return 序号
	 */
	public String getOrderBy() {
		return orderBy;
	}

	/**
	 * @param orderBy 序号
	 */
	public void setOrderBy(String orderBy) {
		this.orderBy = orderBy;
	}


	/**
	 * @return 有效标识
	 */
	public Boolean getActiveFlag() {
		return activeFlag;
	}

	/**
	 * @param activeFlag 有效标识
	 */
	public void setActiveFlag(Boolean activeFlag) {
		this.activeFlag = activeFlag;
	}
	/**
	 * 得到当前树的所有子树
	 *
	 * @return 当前树的所有子树
	 */
	public TreeNode[] getSons() {
		return sons;
	}

	/**
	 * @param son 要添加为子树的数组
	 */
	public void addSons(TreeNode[] son) {
		if(son == null) {
			return;
		}

		if(sons == null) {
			sons = son;
		} else {
			TreeNode temp[] = sons;
			sons = new TreeNode[temp.length + son.length];
			for(int i = 0; i < temp.length; i++) {
				sons[i] = temp[i];
			}

			for(int i = 0; i < son.length; i++) {
				sons[temp.length + i] = son[i];
			}

			temp = null;
		}

		// 将子节点的ParentId指向当前节点的ID，以保证整棵树可以双向查询
		for(TreeNode tn : son) {
			tn.setParentId(getId());
		}
	} // end addSons

	/**
	 * 对子节点进行排序
	 */
	public void sortSons() {
		// 排序
		Arrays.sort(sons);
	}

	/**
	 * @param son 待删除的子树
	 * @return true: 删除成功
	 *         false: 删除未成功
	 */
	public boolean removeSon(TreeNode son) {
		if(sons == null || son == null) return false;

		boolean blSuccess = false;
		for(int i = 0; i < sons.length; i++) {
			if(son.getId() == sons[i].getId()) {
				sons[i] = null;
				blSuccess = true;
				break;
			}
		}

		if(blSuccess) {
			TreeNode temp[] = sons;
			sons = new TreeNode[temp.length - 1];
			int i = 0;
			for(; temp[i] != null && i < sons.length; i++) {
				sons[i] = temp[i];
			}

			for(; i < sons.length; i++) {
				sons[i] = temp[i+1];
			}

			temp = null;
		}

		return blSuccess;
	}

	/**
	 * 测试是否有子树
	 *
	 * @return true:有子树   false:没有子树
	 */
	public boolean hasSon() {
		return (sons != null && sons.length > 0);
	}

	/**
	 * 设置树的顶节点自定义属性
	 *
	 * @param key 属性Key值
	 * @param value 属性值
	 */
	public void setAttribute(Object key, Object value) {
		if(value == null) {
			attribute.remove(key);
		} else {
			attribute.put(key, value);
		}
	}

	/**
	 * 得到所有自定义属性数据
	 *
	 * @return 所有属性数据
	 */
	public Map<Object, Object> getAttributes() {
		return attribute;
	}

	/**
	 * 得到自定义属性值
	 *
	 * @param key 属性Key值
	 * @return 属性值
	 */
	public Object getAttribute(Object key) {
		return attribute.get(key);
	}

	/**
	 * 得到树顶节点的各种自定义属性Key集合
	 * @return 树顶节点的属性Key集合
	 */
	public Iterator<Object> getAttributeKeys() {
		return attribute.keySet().iterator();
	}

	/**
	 * 当前树节点的克隆
	 *
	 * @return 克隆获得的节点
	 */
	public TreeNode cloneNode() {
		TreeNode temp = new TreeNode();
		// 当前树顶节点编号
		temp.setId(getId());
		// 父节点编号
		temp.setParentId(getParentId());
		// 名称
		temp.setName(getName());
		// 有效标识
		temp.setActiveFlag(getActiveFlag());
		// 排序号
		temp.setOrderBy(getOrderBy());
		// 属性
		// 得到被clone节点的属性Key
		Iterator<Object> it = getAttributeKeys();
		while(it != null && it.hasNext()) {
			Object key = it.next();
			Object value = getAttribute(key);
			temp.setAttribute(key, value);
		}

		return temp;
	}

	/**
	 * 整棵树的克隆
	 * 
	 * @return 克隆得到的树
	 */
	public TreeNode clone() {
		TreeNode temp = cloneNode();

		// 处理子节点
		if (hasSon()) {
			TreeNode[] sons = getSons();
			TreeNode[] cpSons = new TreeNode[sons.length];
			for (int i = 0; i < sons.length; i++) {
				cpSons[i] = sons[i].clone();
			}

			temp.addSons(cpSons);
		}

		return temp;
	}

	/**
	 * 用于树节点的排序，比较排序序号的大小
	 * 
	 * @param obj 比较的对象
	 * 
	 * @return 比较结果
	 */
	public int compareTo(Object obj) {
		if(obj instanceof TreeNode) {
			TreeNode temp = (TreeNode)obj;
			return getOrderBy().compareTo(temp.getOrderBy());
		} else {
			return -1;
		}
	}
}
