package team.bangbang.config.service;

import org.ehcache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;

import team.bangbang.common.CommonMPI;
import team.bangbang.common.data.CustomizeCache;
import team.bangbang.common.net.http.HttpClient;
import team.bangbang.common.net.http.ResponseHandler;
import team.bangbang.config.data.Parameter;

/**
 * 系统参数 - Service
 *
 * @author 帮帮组
 * @version 1.0 2018-10-13
 */
public final class ParameterService {
	/* 日志对象 */
	private  final static Logger logger = LoggerFactory.getLogger(ParameterService.class);
	/* 缓存 */
	private static Cache<String, Object> cache = CustomizeCache.createCache("ParameterService", 300);
	/* http请求客户端 */
	private static HttpClient hc = new HttpClient();

	/**
	 * 得到参数值
	 *
	 * @param module        所属模块
	 * @param parameterName 参数名称
	 *
	 * @return 参数值
	 */
	public static Parameter getParameter(String module, String parameterName) {
		String cacheKey = "Parameter:" + module + ":" + parameterName;
		// 检查缓存是否存在
		if(cache != null && cache.containsKey(cacheKey)) {
			try {
				String s = (String)cache.get(cacheKey);
				return JSONObject.parseObject(s).toJavaObject(Parameter.class);
			} catch (Exception ex) {
				return null;
			}
		}

		// 权限管理系统的根地址，包括context-path，以 / 符号结尾
		String consoleRoot = CommonMPI.getConsoleRoot();
		if (consoleRoot == null || consoleRoot.length() < 5) {
			return null;
		}

		if (module == null || module.trim().length() == 0 || parameterName == null
				|| parameterName.trim().length() == 0) {
			return null;
		}

		// 请求服务
		String service = consoleRoot + "api/config/getParameter";

		try {
			ResponseHandler rh = hc.post(service, "module=" + module + "&parameterName=" + parameterName, HttpClient.FormMime);
			JSONObject json = rh.toJSONObject();

			if(rh.getHttpStatus() != 200) {
				logger.error("调用 " + service + " 出现异常：" + json);
				return null;
			}

			// 数据
			json = json.containsKey("dto") ? json.getJSONObject("dto") : null;

			if(cache != null && json != null) {
				cache.put(cacheKey, json != null ? json.toJSONString() : null);
			}

			return (json != null) ? json.toJavaObject(Parameter.class) : null;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("调用 " + service + " 出现异常：" + e.getMessage());
		}

		return null;
	}
}
