package team.bangbang.sso;

import java.util.List;

import team.bangbang.sso.data.Application;

/**
 * 单点登录（服务端、客户端共用） - 应用系统信息
 * 
 * 注意：<br>
 * 此接口的实现类如果依赖Http请求，可以通过SSOContext类获得Http请求。<br>
 * 参见 bean.bangbang.sso.SSOContext#getHttpRequest()
 *
 * @author Bangbang
 * @version 1.0  2020年12月16日
 */
public interface IApplicationSSO {
	/**
	 * @param applicationId 客户端应用的编号
	 * 
	 * @return 客户端应用信息
	 */
	public Application getApplication(String applicationId);
	
	/**
	 * 获得应用信息列表
	 * 
	 * @return 应用信息列表
	 */
	public List<Application> getApplicationList();
}
