package team.bangbang.sso;

import team.bangbang.sso.data.DataLimit;

/**
 * 单点登录（服务端、客户端共用） - 数据权限
 * 
 * 注意：<br>
 * 此接口的实现类如果依赖Http请求，可以通过SSOContext类获得Http请求。<br>
 * 参见 bean.bangbang.sso.SSOContext#getHttpRequest()
 *
 * @author Bangbang
 * @version 1.0  2020年12月16日
 */
public interface IDataLimitSSO {
	/**
	 * @param applicationId 客户端应用的编号
	 * 
	 * @return 指定账户的数据权限
	 */
	public DataLimit getDataLimit(String applicationId);
}
