package team.bangbang.sso;

import java.util.List;

import team.bangbang.sso.data.Menu;

/**
 * 单点登录（服务端、客户端共用）- 功能权限
 * 
 * 注意：<br>
 * 此接口的实现类如果依赖Http请求，可以通过SSOContext类获得Http请求。<br>
 * 参见 bean.bangbang.sso.SSOContext#getHttpRequest()
 *
 * @author Bangbang
 * @version 1.0  2020年12月16日
 */
public interface IFunctionLimitSSO {
	/**
	 * 根据指定应用的菜单列表
	 * 
	 * @param applicationId 客户端应用的编号
	 * @return 菜单列表
	 */
	public abstract List<Menu> getMenu(String applicationId);
	
	/**
	 * 检查指定的地址当前账户是否有权限访问
	 * 
	 * @param applicationId 客户端应用的编号
	 * @param code 权限编码
	 * @param uri 请求URI，WEB Context之后的部分，以“/”符号开头
	 * 
	 * @return 是否有权限访问
	 */
	public boolean canVisit(String applicationId, String code, String uri);
}
