package team.bangbang.sso.data;

import java.util.Map;
import java.util.Set;

/**
 * 当前账户信息
 *
 * @author 帮帮组
 * @version 1.0  2020年11月23日
 * @version 1.1  2021年01月26日  +functions属性：在各个子系统上面的权限，KEY：子系统编号，VALUE：有权限的功能地址/编码集合
 * @version 1.2  2021年01月28日  +mobile属性：手机号码
 */
public class Account {
	/* 账户类型标识{自由定义，依赖于接口实现类具体逻辑} */
	private Integer typeFlag = null;	
	/* 账户编号（在SSO Server中可能是非字符串，统一按字符串处理） */
	private String id = null;
	/* 账户名称 */
	private String name = null;
	/* 所属集团编码 */
	private String corpCode = null;
	/* 所在组织编码 */
	private String organizationCode = null;
	/* 有效标识 */
	private Boolean activeFlag = null;
	/* 欢迎页地址 */
	private String welcomePage = null;
	/* 登录帐号 */
	private String accountNo = null;
	/* 登录密码 */
	private String password = null;
	/* 手机号码 */
	private String mobile = null;
	/* 在各个子系统上面的权限<子系统编号, 有权限的功能地址/编码集合> */
	private Map<String, Set<String>> functions = null;
	/* 拥有的角色编码集合 */
	private Set<String> roleCodes = null;

	/**
	 * @return 账户类型类型标识{自由定义，依赖于接口实现类具体逻辑}
	 */
	public Integer getTypeFlag() {
		return typeFlag;
	}
	/**
	 * @param typeFlag 账户类型类型标识{自由定义，依赖于接口实现类具体逻辑}
	 */
	public void setTypeFlag(Integer typeFlag) {
		this.typeFlag = typeFlag;
	}
	/**
	 * @return 账户编号（在SSO Server中可能是非字符串，统一按字符串处理）
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id 账户编号（在SSO Server中可能是非字符串，统一按字符串处理）
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * @return 账户名称
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name 账户名称
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * @return 所属集团编码
	 */
	public String getCorpCode() {
		return corpCode;
	}
	/**
	 * @param corpCode 所属集团编码
	 */
	public void setCorpCode(String corpCode) {
		this.corpCode = corpCode;
	}
	/**
	 * @return 所在组织编码
	 */
	public String getOrganizationCode() {
		return organizationCode;
	}
	/**
	 * @param organizationCode 所在组织编码
	 */
	public void setOrganizationCode(String organizationCode) {
		this.organizationCode = organizationCode;
	}

	/**
	 * @return 有效标识
	 */
	public Boolean getActiveFlag() {
		return activeFlag;
	}

	/**
	 * @param activeFlag 有效标识
	 */
	public void setActiveFlag(Boolean activeFlag) {
		this.activeFlag = activeFlag;
	}

	/**
	 * @return 欢迎页地址
	 */
	public String getWelcomePage() {
		return welcomePage;
	}

	/**
	 * @param welcomePage 欢迎页地址
	 */
	public void setWelcomePage(String welcomePage) {
		this.welcomePage = welcomePage;
	}

	/**
	 * @return 登录帐号
	 */
	public String getAccountNo() {
		return accountNo;
	}
	/**
	 * @param accountNo 登录帐号
	 */
	public void setAccountNo(String accountNo) {
		this.accountNo = accountNo;
	}
	/**
	 * @return 登录密码
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * @param password 登录密码
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return 手机号码
	 */
	public String getMobile() {
		return mobile;
	}
	
	/**
	 * @param mobile 手机号码
	 */
	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
	/**
	 * @return 在各个子系统上面的权限，KEY：子系统编号，VALUE：有权限的功能地址/编码集合
	 */
	public Map<String, Set<String>> getFunctions() {
		return functions;
	}
	
	/**
	 * @param functions 在各个子系统上面的权限，KEY：子系统编号，VALUE：有权限的功能地址/编码集合
	 */
	public void setFunctions(Map<String, Set<String>> functions) {
		this.functions = functions;
	}
	
	/**
	 * 在指定子系统下检查是否有指定权限编码、请求URI的权限
	 * 
	 * @param applicationId 子系统编号
	 * @param codeOrUri 权限编码、请求URI
	 * @return 是否有权限
	 */
	public boolean hasPermission(String applicationId, String codeOrUri) {
		if (applicationId == null || applicationId.length() == 0
				|| this.getFunctions() == null || this.getFunctions().size() == 0) {
			return false;
		}
		
		// 权限功能地址/编码集合
		Set<String> ss = this.getFunctions().get(applicationId);
		if (ss == null || ss.size() == 0) {
			return false;
		}
		
		codeOrUri = codeOrUri.toUpperCase();
		for(String v : ss) {
			v = v.toUpperCase();
			if (codeOrUri.equals(v)) {
				// 允许单个地址访问
				return true;
			}
			if (!v.endsWith("/")) {
				v += "/";
			}
			if (codeOrUri.startsWith(v)) {
				// 允许整个虚拟目录下的访问
				return true;
			}
		}
		
		return false;
	}
	
	/**
	 * @return 拥有的角色编码集合
	 */
	public Set<String> getRoleCodes() {
		return roleCodes;
	}
	
	/**
	 * @param roleCodes 拥有的角色编码集合
	 */
	public void setRoleCodes(Set<String> roleCodes) {
		this.roleCodes = roleCodes;
	}
	
	/**
	 * 是否拥有指定编码的角色
	 * 
	 * @param roleCode 角色编码
	 * @return 是否拥有指定编码的角色
	 */
	public boolean hasRoleCode(String roleCode) {
		if (roleCodes == null || roleCodes.isEmpty() || roleCode == null || roleCode.trim().length() == 0) {
			return false;
		}
		
		return roleCodes.contains(roleCode.trim());
	}
	
	@Override
	public int hashCode() {
		return (getId() == null)?0:getId().toString().hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if(getId() == null || obj == null || !(obj instanceof Account)) {
			return false;
		}
		return getId().equals(((Account)obj).getId());
	}
}
