package team.bangbang.sso.data;

import java.util.Set;

import team.bangbang.common.sql.DbUtil;

/**
 * 数据权限，管辖范围内的组织节点集合、管辖范围外的组织节点集合
 *
 * @author 帮帮组
 * @version 1.0  2020年11月23日
 */
public class DataLimit {
	/* 管辖范围内的组织节点集合 */
	private Set<?> inScope = null;
	/* 管辖范围外的组织节点集合 */
	private Set<?> outScope = null;
	/**
	 * @return 管辖范围内的组织节点集合
	 */
	public Set<?> getInScope() {
		return inScope;
	}
	/**
	 * @param inScope 管辖范围内的组织节点集合
	 */
	public void setInScope(Set<?> inScope) {
		this.inScope = inScope;
	}

	/**
	 * @return 管辖范围外的组织节点集合
	 */
	public Set<?> getOutScope() {
		return outScope;
	}
	/**
	 * @param outScope 管辖范围外的组织节点集合
	 */
	public void setOutScope(Set<?> outScope) {
		this.outScope = outScope;
	}

	/**
	 * 形成SQL限定条件
	 *
	 * @return SQL限定条件，返回值规范如下：
	 * 			null：管辖范围为空，不查询任何数据
	 * 			""：长度为0的字符串，查询不作限定，可以访问任何数据
	 * 			其它：in或者not in的sql，但不包括字段，如：in (2,3,4,5)
	 */
	public String toSQLWhere() {
		int inCount =  (inScope == null || inScope.isEmpty()) ? 0 : inScope.size();
		int outCount =  (outScope == null || outScope.isEmpty()) ? 0 : outScope.size();

		// inScope还是outScope？
		// 选择一个最少范围，以便产生简短的SQL限定条件
		boolean selectIn = (inCount <= outCount);

		Set<?> ss = selectIn ? inScope : outScope;

		if (ss == null || ss.isEmpty()) {
			// 在空内？
			if (selectIn) {
				// 没有任何管理
				return "1 != 1";
			}

			// 在空之外
			// 管理所有
			return "";
		}

		StringBuffer sb = new StringBuffer();
		for (Object l : ss) {
			if(sb.length() > 0) sb.append(",");
			if (l instanceof String) {
				String no = (String)l;
				// 字符串类型添加双引号
				sb.append("'").append(DbUtil.getDataString(no)).append("'");
			} else {
				sb.append(l);
			}
		}

		sb.insert(0, selectIn ? " in (" : " not in (");
		sb.append(")");

		return sb.toString();
	}
}
