package team.bangbang.sso.data;

import java.util.List;

/**
 * 菜单项
 *
 * @author 帮帮组
 * @version 1.0  2020年12月07日
 */
public class Menu {
	/* 菜单项编号 */
	private String menuId = null;
	/* 父菜单项编号，关联system_user_base.MenuId */
	private String parentId = null;
	/* 父菜单项 */
	private Menu parent = null;
	/* 菜单名称 */
	private String menuName = null;
	/* 图标文件或者class */
	private String iconImage = null;
	/* 排序序号 */
	private String orderBy = null;
	/* 菜单地址，使用'-'号开头表示弹出窗口方式打开 */
	private String menuUrl = null;
	/* 帮助文档可以在其它系统中维护，链接于此 */
	private String helpUrl = null;
	/* 菜单页面功能对外提供的接口地址，推荐使用swagger地址 */
	private String apiUrl = null;
	/* 子菜单项 */
	private List<Menu> sons = null;

	/**
	 * @return 菜单项编号
	 */
	public String getId() {
		return menuId;
	}
	/**
	 * @param menuId 菜单项编号
	 */
	public void setId(String menuId) {
		this.menuId = menuId;
	}
	/**
	 * @return 父菜单项编号，关联system_user_base.MenuId
	 */
	public String getParentId() {
		return parentId;
	}
	/**
	 * @param parentId 父菜单项编号，关联system_user_base.MenuId
	 */
	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	/**
	 * @return 父菜单项
	 */
	public Menu getParent() {
		return parent;
	}

	/**
	 * @param parent 父菜单项
	 */
	public void setParent(Menu parent) {
		this.parent = parent;
	}

	/**
	 * @return 菜单名称
	 */
	public String getMenuName() {
		return menuName;
	}
	/**
	 * @param menuName 菜单名称
	 */
	public void setMenuName(String menuName) {
		this.menuName = menuName;
	}
	/**
	 * @return 图标文件或者class
	 */
	public String getIconImage() {
		return iconImage;
	}
	/**
	 * @param iconImage 图标文件或者class
	 */
	public void setIconImage(String iconImage) {
		this.iconImage = iconImage;
	}
	/**
	 * @return 排序序号
	 */
	public String getOrderBy() {
		return orderBy;
	}
	/**
	 * @param orderBy 排序序号
	 */
	public void setOrderBy(String orderBy) {
		this.orderBy = orderBy;
	}
	/**
	 * @return 菜单地址，使用'-'号开头表示弹出窗口方式打开
	 */
	public String getMenuUrl() {
		return menuUrl;
	}
	/**
	 * @param menuUrl 菜单地址，使用'-'号开头表示弹出窗口方式打开
	 */
	public void setMenuUrl(String menuUrl) {
		this.menuUrl = menuUrl;
	}
	/**
	 * @return 帮助文档可以在其它系统中维护，链接于此
	 */
	public String getHelpUrl() {
		return helpUrl;
	}
	/**
	 * @param helpUrl 帮助文档可以在其它系统中维护，链接于此
	 */
	public void setHelpUrl(String helpUrl) {
		this.helpUrl = helpUrl;
	}
	/**
	 * @return 菜单页面功能对外提供的接口地址，推荐使用swagger地址
	 */
	public String getApiUrl() {
		return apiUrl;
	}
	/**
	 * @param apiUrl 菜单页面功能对外提供的接口地址，推荐使用swagger地址
	 */
	public void setApiUrl(String apiUrl) {
		this.apiUrl = apiUrl;
	}

	/**
	 * @return 子菜单项
	 */
	public List<Menu> getSons() {
		return sons;
	}
	/**
	 * @param sons 子菜单项
	 */
	public void setSons(List<Menu> sons) {
		this.sons = sons;
	}
	@Override
	public int hashCode() {
		return (getId() == null)?0:getId().toString().hashCode();
	}
	@Override
	public boolean equals(Object obj) {
		if(getId() == null || obj == null || !(obj instanceof Menu)) {
			return false;
		}
		return getId().equals(((Menu)obj).getId());
	}
}
