package tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;

import team.bangbang.common.config.Constants;
import team.bangbang.common.file.FileWriter;

/**
 * 将UTF-8 BOM字符集的文本转化为UTF-8字符集
 *
 * @author 帮帮组
 * @version 1.0 2018-04-06
 */
public class BOMRemove {
	/* 文件计数 */
	private static int nCount = 0;
	/* 文本文件的扩展名 */
	private static String[] exts = { ".java"};

	/**
	 * @param args
	 *            传入的第一个参数表示需要操作的文本文件目录<br>
	 *            传入的第二个参数表示目标字符集
	 */
	public static void main(String[] args) {
		if (args == null || args.length < 1) {
			System.out
					.println("Usage:"
							+ Constants.LINE_SEPARATOR
							+ " Java -cp <bangbang_common.jar> "
							+ "cn.js.tools.BOMRemove [source directory]");
			System.exit(0);
		}

		// 得到源文件目录
		File f = new File(args[0]);
		if (!f.exists()) {
			System.out.println("The source directory speciafied is not exist.");
			System.exit(0);
		}

		changeEncoding(f);
		System.out.println("Summary: " + nCount + " file(s) processed.");
	}

	/**
	 * 转换一个目录或者文件中的内容。
	 *
	 * @param file
	 *            指定的目录或者文件
	 */
	private static void changeEncoding(File file) {
		if (file.isDirectory()) {
			// 该File是目录
			// 列出其下的所有文件进行递归
			File[] sons = file.listFiles();
			for (int i = 0; sons != null && i < sons.length; i++) {
				changeEncoding(sons[i]);
			}

			return;
		}

		// 该File是文件
		try {
			if (isTextFile(file)) {
				contentTranslate(file);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} // end try
	}

	/**
	 * 根据文件扩展名，判断是否是文本文件
	 *
	 * @param f
	 *            指定的文件
	 * @return true:文本文件 false:非文本文件
	 */
	private static boolean isTextFile(File f) {
		String fileName = f.getName().toLowerCase();
		for(String str : exts) {
			if(fileName.endsWith(str)) {
				return true;
			}
		}

		return false;
	}

	/**
	 * 文件字符集转换
	 *
	 * @param f
	 *            指定的文件
	 */
	private static void contentTranslate(File f) throws Exception {
		FileInputStream fis = new FileInputStream(f);
		// 读出文件内容
		UnicodeReader reader = new UnicodeReader(fis, "UTF-8");
		BufferedReader br = new BufferedReader(reader);

		StringBuffer sb = new StringBuffer();
		int len = 512;
		char[] buff = new char[len];
		while((len = br.read(buff)) > 0) {
			sb.append(buff, 0, len);
		}
		fis.close();
		br.close();

		if (sb.length() == 0) {
			System.out.println("Ignore file " + f.getCanonicalPath());
			return;
		}

		// 写入文件
		FileWriter writer = new FileWriter(f);
		writer.writeString(sb.toString(), "UTF-8");

		System.out.println(f.getCanonicalPath());
		nCount++;
	}
}
