package tools;

import team.bangbang.common.cipher.BangbangCipher;
import team.bangbang.common.file.FileReader;
import team.bangbang.common.file.FileWriter;

/**
 *
 * @author 帮帮组
 * @version 1.0   2008-3-24
 */
public class CipherTest {

	/**
	 * @param args 命令行参数
	 * @throws Exception 异常
	 */
	public static void main(String[] args) throws Exception {
		// 需要加密的文件
		String fromFile = "F:\\mingwen.txt";
		// 加密后的文件
		String toFile = "F:\\miwen.dat";
		// 密钥
		byte[] key = "123456789".getBytes();
		// 读取文件
		FileReader fr = new FileReader(fromFile);
		byte[] content = fr.readBytes();
		byte[] bts = BangbangCipher.encryptDES(content, key);

		// 写文件
		FileWriter fw = new FileWriter(toFile);
		fw.writeBytes(bts);

		// 解密
		bts = BangbangCipher.decryptDES(bts, key);
		// 输出
		System.out.println(new String(bts));
	}
}
