package tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 读取指定的目录下源文件，汇总输出到一个txt文档中
 *
 * @author 帮帮组
 * @version 1.0 2007-9-20
 */
public class Code2File {
	/* 文件计数 */
	private static int nCount = 0;

	/**
	 * @param args
	 *            传入的第一个参数表示需要操作的Java源文件目录
	 */
	public static void main(String[] args) {
		if (args == null || args.length == 0) {
			System.out.println("Usage: Java -cp <bangbang_common.jar> "
					+ "cn.js.tools.Code2File [source directory] [target file]");
			System.exit(0);
		}

		// 得到源文件目录
		File f = new File(args[0]);
		if (!f.exists()) {
			System.out.println("The source directory speciafied is not exist.");
			System.exit(0);
		}

		// 获得目标文件
		File tf = new File(args[1]);
		File pf = tf.getParentFile();
		if (!pf.exists()) {
			pf.mkdirs();
		}

		appendCode(f, tf);
		System.out.println("Summary: " + nCount + " file(s) processed.");
	}

	private static void appendCode(File f1, File f2) {
		if (f1.isDirectory()) {
			// 该File是目录
			// 列出其下的所有文件进行递归
			File[] sons = f1.listFiles();
			for (int i = 0; sons != null && i < sons.length; i++) {
				appendCode(sons[i], f2);
			}

			return;
		}

		if (!f1.exists()) {
			return;
		}

		// 该File是文件
		InputStream is = null;
		OutputStream os = null;
		byte[] buff = new byte[1024];
		int len = 0;
		try {
			is = new FileInputStream(f1);
			os = new FileOutputStream(f2, true);

			nCount++;

			// 输入文件的名称
			System.out.println(nCount + "\t" + f1.getAbsolutePath());
			os.write(("[" + f1.getAbsolutePath() + "]\r\n\r\n").getBytes());

			while ((len = is.read(buff)) > 0) {
				os.write(buff, 0, len);
			}

			os.write("\r\n\r\n\r\n".getBytes());
			os.flush();
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			try {
				if (is != null)
					is.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
			try {
				if (os != null)
					os.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		} // end try
	}
}
