package tools;

import java.io.File;
import java.io.IOException;
import java.util.Map;

import team.bangbang.common.config.Constants;
import team.bangbang.common.file.FileReader;
import team.bangbang.common.utility.TemplateDraw;

/**
 * 获得Java文件的类注释
 *
 * @author 帮帮组
 * @version 1.0 2010-07-19
 */
public class CommentGetter {
	/* 文件计数 */
	private static int nCount = 0;
	/* 文本文件的扩展名 */
	private static String[] exts = { ".java" };
	/* 套取器 */
	private static TemplateDraw drawer = null;
	/* 上一个包 */
	private static String lastPackage = null;

	/**
	 * @param args
	 *            传入的第一个参数表示需要操作的源文件目录
	 * @throws IOException 文件IO异常
	 */
	public static void main(String[] args) throws IOException {
		if (args == null || args.length < 1) {
			System.out
					.println("Usage:"
							+ Constants.LINE_SEPARATOR
							+ " Java -cp <bangbang_common.jar> "
							+ "cn.js.tools.CommentGetter [source directory]");
			System.exit(0);
		}

		// 得到源文件目录
		File f = new File(args[0]);
		if (!f.exists()) {
			System.out.println("The source directory speciafied is not exist.");
			System.exit(0);
		}

		drawer = new TemplateDraw("comment.tpl");

		// 迭代该目录下所有文件
		iterateFiles(f);
		System.out.println("Summary: " + nCount + " file(s) processed.");
	}

	/**
	 * 处理一个目录或者文件中的内容。
	 *
	 * @param file
	 *            指定的目录或者文件
	 */
	private static void iterateFiles(File file) {
		if (file.isDirectory()) {
			// 该File是目录
			// 列出其下的所有文件进行递归
			File[] sons = file.listFiles();
			for (int i = 0; sons != null && i < sons.length; i++) {
				iterateFiles(sons[i]);
			}

			return;
		}

		// 该File是文件
		try {
			if (isTextFile(file)) {
				// 得到注释信息
				drawComments(file);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} // end try
	}

	/**
	 * 根据文件扩展名，判断是否是文本文件
	 *
	 * @param f
	 *            指定的文件
	 * @return true:文本文件 false:非文本文件
	 */
	private static boolean isTextFile(File f) {
		String fileName = f.getName().toLowerCase();
		for (String str : exts) {
			if (fileName.endsWith(str)) {
				return true;
			}
		}

		return false;
	}

	/**
	 * 得到注释信息
	 *
	 * @param f
	 *            指定的文件
	 */
	private static void drawComments(File f) throws Exception {
		// 读出文件内容
		FileReader reader = new FileReader(f);
		String content = reader.readString();

		Map<String, String> mp = drawer.drawDatas(content);

		// 包名
		String packageName = mp.get("package");
		if(packageName == null || !packageName.endsWith(".action")) {
			return;
		}

		// 注释
		String comment = getComment(mp.get("comment"));
		if(comment == null || comment.trim().length() == 0) {
			return;
		}

		// 类名
		String clazzName = getClazzName(f.getName());

		if(!packageName.equals(lastPackage)) {
			lastPackage = packageName;
			System.out.println("包：" + packageName);
		}
		System.out.println("\t" + clazzName + " \t " + comment);

		nCount++;
	}

	private static String getComment(String string) {
		if(string == null || string.length() == 0) return null;

		int nIndex = string.indexOf("@");
		if(nIndex > 0) {
			string = string.substring(0, nIndex);
		}

		string = string.replace('*', ' ');

		return string.trim();
	}

	private static String getClazzName(String name) {
		int nIndex = name.lastIndexOf(".");

		return (nIndex > 0) ? name.substring(0, nIndex) : null;
	}
}
