package tools;

import java.io.File;

import team.bangbang.common.file.FileReader;
import team.bangbang.common.file.FileWriter;

/**
 * 去除指定文件夹下所有子目录中Java源文件的注释，注释包括两种格式：多行注释、单行注释
 *
 * @author 帮帮组
 * @version 1.0 2007-9-20
 */
public class CommentRemove {
	/* 文件计数 */
	private static int nCount = 0;

	/**
	 * @param args
	 *            传入的第一个参数表示需要操作的Java源文件目录
	 */
	public static void main(String[] args) {
		if (args == null || args.length == 0) {
			System.out.println("Usage: Java -cp <bangbang_common.jar> "
					+ "cn.js.tools.CommentRemove [source directory]");
			System.exit(0);
		}

		// 得到源文件目录
		File f = new File(args[0]);
		if (!f.exists()) {
			System.out.println("The source directory speciafied is not exist.");
			System.exit(0);
		}

		removeComment(f);
		System.out.println("Summary: " + nCount + " file(s) processed.");
	}

	/**
	 * 删除一个目录或者文件中的注释语句。
	 *
	 * @param file
	 *            指定的目录或者文件
	 */
	private static void removeComment(File file) {
		if (file.isDirectory()) {
			// 该File是目录
			// 列出其下的所有文件进行递归
			File[] sons = file.listFiles();
			for (int i = 0; sons != null && i < sons.length; i++) {
				removeComment(sons[i]);
			}

			return;
		}

		// 该File是文件
		try {
			System.out.println(file.getCanonicalPath());
			contentReplaced(file);
			nCount++;
		} catch (Exception ex) {
			ex.printStackTrace();
		} // end try
	}

	/**
	 * 文件内容替换
	 *
	 * @param f
	 *            指定的文件
	 */
	private static void contentReplaced(File f) throws Exception {
		// 读出文件内容
		FileReader reader = new FileReader(f);
		String content = reader.readString();

		// 去掉单行注释
		content = content.replaceAll("\\s*//[^\n]*[\n]+", "\r\n");
		// 去掉多条注释
		// "/*"的位置
		int nIndex = -1;
		while ((nIndex = content.indexOf("/*")) >= 0) {
			String str = "";
			// 注释前的字符串
			if(nIndex > 0) {
				str = content.substring(0, nIndex);
			}

			// 注释后的字符串
			nIndex = content.indexOf("*/", nIndex + 2);
			if(nIndex > 0) {
				str += content.substring(nIndex + 2);
			}

			content = str;
		}

		// 写入文件
		FileWriter writer = new FileWriter(f);
		writer.writeBytes(content.getBytes());
	}
}
