package tools;

import java.sql.SQLException;
import java.util.Date;

import team.bangbang.common.data.Pagination;
import team.bangbang.common.data.RecordData;
import team.bangbang.common.sql.SQLHelper;

/**
 * 数据库查询
 *
 * @author 帮帮组
 * @version 1.0  2019年5月24日
 */
public class DBQuery {

	/**
	 * @param args 命令行参数
	 * @throws SQLException SQL异常
	 */
	public static void main(String[] args) throws SQLException {
		SQLHelper helper = new SQLHelper();

		insert(helper);

		update(helper);

		delete(helper);

		query(helper);

		helper.close();
	}

	private static void insert(SQLHelper helper) throws SQLException {
		RecordData wd = new RecordData();
		wd.setTable("TEST_ORGANIZATION");

		wd.setSingleData("OrgName", "测试单位");
		wd.setSingleData("ActiveFlag", false);
		wd.setSingleData("Remark", "备注信息");
		wd.setSingleData("UpdateTime", new Date());

		int n = helper.insert(wd);
		helper.commit();
		System.out.println("插入结果：" + n);
	}

	private static void update(SQLHelper helper) throws SQLException {
		RecordData wd = new RecordData();
		wd.setTable("TEST_ORGANIZATION");
		wd.setSubWhere("OrgId = 0");

		wd.setSingleData("ActiveFlag", true);
		wd.setSingleData("UpdateTime", new Date());

		int n = helper.update(wd);
		helper.commit();
		System.out.println("修改结果：" + n);
	}

	private static void delete(SQLHelper helper) throws SQLException {
		RecordData wd = new RecordData();
		wd.setTable("TEST_ORGANIZATION");
		wd.setSubWhere("OrgId = 1");

		int n = helper.delete(wd);
		helper.commit();
		System.out.println("删除结果：" + n);
	}

	private static void query(SQLHelper helper) throws SQLException {
		RecordData wd = new RecordData();

		// 查单行数据
		String sql = "select sum(FeeAmount) TotalAmount from fee_fee_base";
		helper.querySingleData(sql, wd);

		System.out.println("总费用是：" + wd.getSingleInt("TotalAmount"));

		// 查询多条数据
		sql = "select * from TL_LOCATION_HISTORY WHERE CAR_ID = 26";
		// 分页数据
		Pagination p = new Pagination();
		wd.setPagination(p);

		helper.queryMultipleData(sql, wd, true);
		System.out.print(wd.size());
		while(wd.next()) {
			System.out.println(wd.getMultipleData("字段名"));
		}
	}
}
