package tools;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import team.bangbang.common.config.Config;
import team.bangbang.common.sql.SQLPool;
import team.bangbang.common.sql.generator.TableKeyMetaData;

/**
 * 获得数据库中所有的表，按字母顺序排列后输出
 *
 * @author 帮帮组
 * @version 1.0 2018年4月6日
 */
public class DBTableList {

	/**
	 * @param args 命令行参数
	 */
	public static void main(String[] args) {
		String alias = "application";
		Set<String> tbls = TableKeyMetaData.getTables(alias);

		List<String> lst = new ArrayList<String>();
		for(String table : tbls) {
			lst.add(table);
		}

		Collections.sort(lst);

		for(int i = 0; i < lst.size(); i++) {
			String table = lst.get(i);
			getFields(alias, table);
		}
	}
	private static Map<String, Field> getFields(String alias, String table) {
		Map<String, Field> mp = new HashMap<String, Field>();
		// 获取default数据库表字段
		// 数据库链接
		Connection conn = null;
		// 结果记录集
		ResultSet rs = null;

		try {
			// 获得数据库的连接
			conn = SQLPool.getConnection(alias);

			String catalog = conn.getCatalog();
			DatabaseMetaData dmd = conn.getMetaData();
			// 读取设定的Schema
			String schema = getSchema(dmd, alias);
			// 关键关键字段的类型、长度
			rs = dmd.getColumns(catalog, schema, table, null);
			String lastTalbe = null;
			if (rs != null) {
				while (rs.next()) {
					Field f = new Field();
					f.name = rs.getString("COLUMN_NAME");
					f.type = rs.getString("TYPE_NAME").toLowerCase();

					if(f.type.equals("bigint") || f.type.equals("tinyint") || f.type.indexOf("date") > 0 || f.type.indexOf("time") > 0) {
						// 省略长度
						f.size = rs.getInt("COLUMN_SIZE");
					} else {
						f.size = rs.getInt("COLUMN_SIZE");
					}

					if(f.name.equalsIgnoreCase("GCUST_ID") && f.size < 20 && !table.equals(lastTalbe)) {
						System.out.println("alter table " + table + " modify " + f.name + " number(20);");
						lastTalbe = table;
					}
					mp.put(f.name, f);
				}
				rs.close();
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException se) {
				}
			}

			if (conn != null) {
				try {
					conn.close();
				} catch (SQLException se) {
				}
			}
		}

		return mp;
	}


	/**
	 * 获得指定数据库的schema名称
	 *
	 * @param dmd
	 *            数据库连接元数据
	 *
	 * @param alias
	 *            数据库别名
	 * @return 数据库的schema名称
	 */
	private static String getSchema(DatabaseMetaData dmd, String alias) {
		// 读取设定的Schema
		String schema = Config.getProperty(alias + ".connection.schema");

		// 如果没有设定Schema，使用用户名
		if (schema == null) {
			String username = Config
					.getProperty(alias + ".connection.username");
			// 获取数据库的schema
			ResultSet rs = null;
			try {
				rs = dmd.getSchemas();
				while (rs != null && rs.next()) {
					String temp = rs.getString(1);
					if (temp != null && temp.equalsIgnoreCase(username)) {
						schema = temp;
						break;
					}
				}
			} catch (Exception exp) {
				exp.printStackTrace();
			} finally {
				if (rs != null) {
					try {
						rs.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
			}
		}

		// 这种情况发生在SQL Server中使用sa访问，schema为dbo的时候
		if (schema != null && schema.trim().length() == 0) {
			schema = null;
		}

		return schema;
	}
}
