package tools;

import java.util.List;

import org.apache.poi.ss.usermodel.CellType;

import team.bangbang.common.file.ExcelColumn;
import team.bangbang.common.file.ExcelDataChecker;

/**
 * Excel数据检查
 *
 * @author Xianjun
 */
public class ExcelDataCheckTest {
	/**
	 * 检查规则定义类
	 */
	private class Rule {
		@ExcelColumn(index=1, type=CellType.NUMERIC, min=2, max=9, required=true)
		private Object col1;
		@ExcelColumn(index=2, type=CellType.STRING, required=true)
		private Object col2;
	}
	/**
	 * @param args 命令行参数
	 * @throws Exception 异常
	 */
	public static void main(String[] args) throws Exception {
		// Excel文件（可以自己定义excel文件并修改内部类Rule然后测试）
		String file = "E:\\report.xlsx";
		// 检查的工作簿序号
		int sheetIndex = 1;
		// 开始行
		int fromRow = 2;
		
		ExcelDataChecker checker = new ExcelDataChecker(file, sheetIndex, Rule.class, fromRow);
		List<String> results = checker.check();
		
		if (results == null || results.isEmpty()) {
			System.out.println("检查全部通过！");
		} else {
			// 打印错误信息
			System.out.println("检查发现错误 " + results.size() + " 条：");
			for(int i = 0; i < results.size(); i++) {
				System.out.println(results.get(i));
			}
		}
	}
}
