package tools;

import java.awt.Dimension;
import java.util.Date;

import team.bangbang.common.file.ExcelWriter;

/**
 * 测试Excel读写
 *
 * @author Xianjun
 */
public class ExcelWriterTest {

	/**
	 * @param args 命令行参数
	 */
	public static void main(String[] args) {
		String tplFile = "D:\\template.xlsx";
		// Excel文件
		String file = "D:\\report.xlsx";
		ExcelWriter ew = null;
		try {
			ew = new ExcelWriter(tplFile, file);
			ew.createSheet("第一个工作簿");
			// 从第2行第2列开始写
			ew.toRow(1);
			ew.toColumn(1);
			String[] headers = { "序号", "学生姓名", "学号" };
			// 记录位置1
			Dimension off1 = ew.getOffset();
			for (String s : headers) {
				ew.writeCell(s);
			}

			// 记录位置2
			Dimension off2 = ew.getOffset();
			// 设置表头样式
			ew.setHeader(off1, off2);

			// 换行
			ew.nextRow();
			// 第2列开始
			ew.toColumn(1);
			// 记录位置3
			Dimension off3 = ew.getOffset();
			
			// 写数据
			for (int i = 0; i < 10; i++) {
				if (i > 0) {
					ew.nextRow();
					// 第2列开始
					ew.toColumn(1);
				}

				ew.writeCell(i + 1);
				ew.writeCell("张三 " + i);
				ew.writeCell("No. " + i);
			}

			// 记录位置3
			Dimension off4 = ew.getOffset();
			// 设置表格边框样式
			ew.setBorder(off3, off4);

			// 在第13行，第1列写文字（游标换行后自动转向第1列）
			ew.toRow(12);
			// 第2列开始
			ew.toColumn(1);

			// 记录位置5
			Dimension off5 = ew.getOffset();
			
			ew.writeCell(new Date());
			ew.writeCell("hahaha2");
			ew.writeCell("hahaha3");
			// 记录位置6
			Dimension off6 = ew.getOffset();
			// 设置脚部样式
			ew.setFooter(off5, off6);
			
			// 设置第2列宽度
			ew.setColumnWidth(1, 40);
			// 设置最后一行高度
			ew.setRowHeight(off6.height, 40);
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			try {
				if (ew != null)
					ew.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		} // end try
	}
}
