package tools;

import java.io.File;

import team.bangbang.common.config.Constants;
import team.bangbang.common.file.FileReader;
import team.bangbang.common.file.FileWriter;

/**
 * 更改指定文件夹下所有子目录中文本文件字符集。
 *
 * @author 帮帮组
 * @version 1.0 2009-03-10
 */
public class FileEncodingChange {
	/* 文件计数 */
	private static int nCount = 0;
	/* 源文件字符集 */
	private static String sourceEncoding = null;
	/* 目标文件字符集（默认UTF-8） */
	private static String encoding = "UTF-8";
	/* 文本文件的扩展名 */
	private static String[] exts = { ".jsp", ".xml", ".java", ".js",
			".properties", ".html", ".htm", ".css"};

	/**
	 * @param args
	 *            传入的第一个参数表示需要操作的文本文件目录<br>
	 *            传入的第二个参数表示目标字符集
	 */
	public static void main(String[] args) {
		if (args == null || args.length < 2) {
			System.out
					.println("Usage:"
							+ Constants.LINE_SEPARATOR
							+ " Java -cp <bangbang_common.jar> "
							+ "cn.js.tools.FileEncodingChange [source directory] [source encoding] [target encoding]");
			System.exit(0);
		}

		// 得到源文件目录
		File f = new File(args[0]);
		if (!f.exists()) {
			System.out.println("The source directory speciafied is not exist.");
			System.exit(0);
		}

		// 源文件字符集
		sourceEncoding = args[1];

		// 目标字符集
		if (args.length > 2) {
			encoding = args[2];
		}

		changeEncoding(f);
		System.out.println("Summary: " + nCount + " file(s) processed.");
	}

	/**
	 * 转换一个目录或者文件中的内容。
	 *
	 * @param file
	 *            指定的目录或者文件
	 */
	private static void changeEncoding(File file) {
		if (file.isDirectory()) {
			// 该File是目录
			// 列出其下的所有文件进行递归
			File[] sons = file.listFiles();
			for (int i = 0; sons != null && i < sons.length; i++) {
				changeEncoding(sons[i]);
			}

			return;
		}

		// 该File是文件
		try {
			if (isTextFile(file)) {
				contentTranslate(file);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} // end try
	}

	/**
	 * 根据文件扩展名，判断是否是文本文件
	 *
	 * @param f
	 *            指定的文件
	 * @return true:文本文件 false:非文本文件
	 */
	private static boolean isTextFile(File f) {
		String fileName = f.getName().toLowerCase();
		for(String str : exts) {
			if(fileName.endsWith(str)) {
				return true;
			}
		}

		return false;
	}

	/**
	 * 文件字符集转换
	 *
	 * @param f
	 *            指定的文件
	 */
	private static void contentTranslate(File f) throws Exception {
		// 读出文件内容
		FileReader reader = new FileReader(f);
		String content = reader.readString(sourceEncoding);
		if (content == null || content.length() == 0) {
			System.out.println("Ignore file " + f.getCanonicalPath());
			return;
		}

		System.out.println(f.getCanonicalPath());
		// 写入文件
		FileWriter writer = new FileWriter(f);
		writer.writeString(content, encoding);
		nCount++;
	}
}
