package tools;

import java.io.File;

import team.bangbang.common.cipher.BangbangCipher;
import team.bangbang.common.file.FileReader;
import team.bangbang.common.file.FileWriter;

/**
 * 对指定文件夹下所有子目录中Java类文件进行简单加密<br>
 *
 * @author 帮帮组
 * @version 1.0 2009-10-17
 */
public class FileEncrypt {
	/* 文件计数 */
	private static int nCount = 0;
	/* 后缀 */
	private static String suffix = "0919 bangbang";
	/**
	 * @param args
	 *            传入的第一个参数表示需要操作的Java源文件目录
	 */
	public static void main(String[] args) {
		if (args == null || args.length < 2) {
			System.out.println("Usage: java -cp <bangbang_common.jar> "
					+ "cn.js.tools.FileEncrypt [source directory] [cpu_id]");
			System.exit(0);
		}

		// 得到源文件目录
		File f = new File(args[0]);
		if (!f.exists()) {
			System.out.println("The source directory speciafied is not exist.");
			System.exit(0);
		}

		// 加密的KEY
		String key = args[1] + suffix;
		// MD5 转换
		byte[] btKey = BangbangCipher.digest(key.getBytes(), BangbangCipher.MD5);
		doEncrypt(f, btKey);
		System.out.println("Summary: " + nCount + " file(s) processed.");
	}

	/**
	 * 对一个目录下所有文件或者某一具体文件进行加密。
	 *
	 * @param file
	 *            指定的目录或者文件
	 * @param btKey 加密的KEY
	 */
	private static void doEncrypt(File file, byte[] btKey) {
		if (file.isDirectory()) {
			// 该File是目录
			// 列出其下的所有文件进行递归
			File[] sons = file.listFiles();
			for (int i = 0; sons != null && i < sons.length; i++) {
				doEncrypt(sons[i], btKey);
			}

			return;
		}

		// 该File是文件
		try {
			System.out.println(file.getCanonicalPath());
			replaceContent(file, btKey);
			nCount++;
		} catch (Exception ex) {
			ex.printStackTrace();
		} // end try
	}

	/**
	 * 使用加密后的内容替换原有文件内容
	 *
	 * @param f
	 *            指定的文件
	 * @param btKey 加密的KEY
	 */
	private static void replaceContent(File f, byte[] btKey) throws Exception {
		// 读出文件内容
		FileReader reader = new FileReader(f);
		byte[] bts = reader.readBytes();

		int nLen = bts.length;
		int keyLen = btKey.length;

		for(int i = 0; i < nLen; i++) {
			bts[i] ^= (btKey[i % keyLen] & 0xFF);
		}

		// 写入文件
		FileWriter writer = new FileWriter(f);
		writer.writeBytes(bts);
	}
}
