package tools;

import java.io.File;

import team.bangbang.common.config.Constants;
import team.bangbang.common.file.IFileManager;
import team.bangbang.common.file.QiniuOssManager;

/**
 * 将指定目录下的所有文件上传到七牛云上
 *
 * @author 帮帮组
 * @version 1.0 2018年5月19日
 */
public class QiniuUpload {
	/* 文件计数 */
	private static int nCount = 0;
	/* 文件上传、下载处理器接口 */
	private static IFileManager ifm = new QiniuOssManager();
	/* 本地文件目录长度 */
	private static int localRootLen = 0;

	/**
	 * @param args
	 *            传入的第一个参数表示需要上传的文件目录
	 */
	public static void main(String[] args) {
		if (args == null || args.length < 1) {
			System.out
					.println("Usage:"
							+ Constants.LINE_SEPARATOR
							+ " Java -cp <bangbang_common.jar> "
							+ "cn.js.tools.QiniuUpload [source directory]");
			System.exit(0);
		}

		// 得到文件目录
		File f = new File(args[0]);
		if (!f.exists()) {
			System.out.println("The source directory speciafied is not exist.");
			System.exit(0);
		}

		String localRoot = (f.isDirectory() ? f.getAbsolutePath() : f.getParent());

		String seq = System.getProperty("file.separator");
		if(!localRoot.endsWith(seq)) {
			localRoot += seq;
		}

		System.out.println("LOCAL ROOT IS " + localRoot);
		localRootLen = localRoot.length();

		doUpload(f);
		System.out.println("Summary: " + nCount + " file(s) processed.");
	}


	/**
	 * 上传一个目录或者文件中的内容。
	 *
	 * @param file
	 *            指定的目录或者文件
	 */
	private static void doUpload(File file) {
		if (file.isDirectory()) {
			// 该File是目录
			// 列出其下的所有文件进行递归
			File[] sons = file.listFiles();
			for (int i = 0; sons != null && i < sons.length; i++) {
				doUpload(sons[i]);
			}

			return;
		}

		// 该File是文件
		try {
			String lf = file.getAbsolutePath();
			String rf = lf.substring(localRootLen).replaceAll("\\\\", "/");

			nCount++;

			System.out.print(nCount + ". uploading " + lf + " to " + rf + ",");
			String url = ifm.put(file.getAbsolutePath(), rf);

			System.out.println(" return url: " + url);
		} catch (Exception ex) {
			ex.printStackTrace();
		} // end try
	}
}
