package tools;

import com.alibaba.fastjson.JSONObject;

import team.bangbang.common.file.FileReader;
import team.bangbang.common.service.agent.ResponseTransform;
import team.bangbang.common.service.agent.XmlLoader;
import team.bangbang.common.service.agent.data.RestfulAgents;

/**
 * RESTful测试
 *
 * 本测试页面必须在application.properties进行以下配置: <br>
 * service.restful.company=<span style="color:red;">team.bangbang.cloud.company.mpi.CompanyREST</span>
 *
 * @author 帮帮组
 * @version 1.0  2014-9-8
 */
public class RESTTest {

	/**
	 * @param args 命令行参数
	 * @throws Exception 异常
	 */
	public static void main(String[] args) throws Exception {
		FileReader fr = new FileReader("E:\\a.txt");
		String s = fr.readString("UTF-8");
		JSONObject ret = JSONObject.parseObject(s);

		System.out.println("3. 请求返回值 ========= =============================== ");
		System.out.println(ret);

		RestfulAgents ras = XmlLoader.load(RESTTest.class, "xml/RestfulAgent.xml");

		// 4. 返回值变换
		ResponseTransform rtt = new ResponseTransform();
		rtt.setFromData(ret);
		JSONObject ret2 = rtt.getToData(ras.getAgent("queryDaiBanList.action"));

		System.out.println("4. 返回值变换 ======================================== ");
		System.out.println(ret2);
	}
}
