package tools;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

import team.bangbang.common.cipher.BangbangCipher;

/**
 * 测试RSA加密和解密
 *
 * @author Xianjun
 */
public class RSATest {

	/**
	 * @param args 命令行参数
	 * @throws Exception 异常
	 */
	public static void main(String[] args) throws Exception {
		String s = "我们都很好！邮件：@sina.com";

		KeyPair pair = BangbangCipher.getRSAKeyPair();

		PublicKey publicKey = pair.getPublic();
		PrivateKey privateKey = pair.getPrivate();

		// 网络传递公钥、私钥时只需要传递公钥、私钥的指数和模数
		// 接收方接收到指数和模数后，重新构建成RSAPublicKey、RSAPrivateKey对象
		BigInteger n1 = ((RSAPublicKey)publicKey).getModulus();
		BigInteger n2 = ((RSAPublicKey)publicKey).getPublicExponent();

		PublicKey key1 = BangbangCipher.recoverRSAPublicKey(n1, n2);

		n1 = ((RSAPrivateKey)privateKey).getModulus();
		n2 = ((RSAPrivateKey)privateKey).getPrivateExponent();
		PrivateKey key2 = BangbangCipher.recoverRSAPrivateKey(n1, n2);

		System.out.println("公钥：\n"
				+ BangbangCipher.byte2hex(publicKey.getEncoded()));
		System.out.println("公钥：\n"
				+ BangbangCipher.byte2hex(key1.getEncoded()));
		System.out.println("私钥：\n"
				+ BangbangCipher.byte2hex(privateKey.getEncoded()));
		System.out.println("私钥：\n"
				+ BangbangCipher.byte2hex(key2.getEncoded()));

		// 加密
		byte[] data = BangbangCipher.encryptRSA(s.getBytes(), publicKey);
		// 解密
		byte[] d1 = BangbangCipher.decryptRSA(data, privateKey);
		System.out.println(new String(d1));
		byte[] d2 = BangbangCipher.decryptRSA(data, key2);
		System.out.println(new String(d2));
	}
}
