package tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import team.bangbang.common.config.Constants;
import team.bangbang.common.file.FileReader;

/**
 * 将指定文件夹下所有源代码文件复制到一个目标文件中。
 *
 * @author 帮帮组
 * @version 1.0 2014-02-26
 */
public class SourceCombine {
	/* 文件计数 */
	private static int nCount = 0;
	/* 源代码文件文件的扩展名 */
	private static String[] exts = { ".jsp", ".java", ".html", ".htm" };
	/* 目标文件 */
	private static FileWriter fw = null;

	/**
	 * @param args
	 *            传入的第一个参数表示需要操作的文本文件目录<br>
	 *            传入的第二个参数表示目标字符集
	 * @throws IOException 异常
	 */
	public static void main(String[] args) throws IOException {
		if (args == null || args.length < 2) {
			System.out.println("Usage:" + Constants.LINE_SEPARATOR
					+ " Java team.bangbang.tools.SourceCombine "
					+ " [source directory] [target file]");
			System.exit(0);
		}

		// 得到源代码文件目录
		File sf = new File(args[0]);
		if (!sf.exists()) {
			System.out.println("The source directory speciafied is not exist.");
			System.exit(0);
		}

		// 目标文件
		File tf = new File(args[1]);
		// 父目录
		File p_tf = tf.getParentFile();
		if(!p_tf.exists()) {
			p_tf.mkdirs();
		}

		fw = new FileWriter(tf);

		copyFile(sf);

		fw.close();
		System.out.println("Summary: " + nCount + " file(s) processed.");
	}

	/**
	 * 复制一个目录或者文件中的内容。
	 *
	 * @param file
	 *            指定的目录或者文件
	 */
	private static void copyFile(File file) {
		if (file.isDirectory()) {
			// 该File是目录
			// 列出其下的所有文件进行递归
			File[] sons = file.listFiles();
			for (int i = 0; sons != null && i < sons.length; i++) {
				copyFile(sons[i]);
			}

			return;
		}

		// 该File是文件
		try {
			if (isSourceFile(file)) {
				copySource(file);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} // end try
	}

	/**
	 * 根据文件扩展名，判断是否是源代码文件
	 *
	 * @param f
	 *            指定的文件
	 * @return true:源代码文件 false:非源代码文件
	 */
	private static boolean isSourceFile(File f) {
		String fileName = f.getName().toLowerCase();
		for (String str : exts) {
			if (fileName.endsWith(str)) {
				return true;
			}
		}

		return false;
	}

	/**
	 * 复制一个源代码文件到目标文件中
	 *
	 * @param f
	 *            指定的文件
	 * @throws Exception 异常
	 */
	private static void copySource(File f) throws Exception {
		// 读出文件内容
		FileReader reader = new FileReader(f);
		String content = reader.readString();
		if (content == null || content.length() == 0) {
			System.out.println("Ignore file " + f.getCanonicalPath());
			return;
		}

		System.out.println(f.getCanonicalPath());
		// 写入空行
		fw.write(Constants.LINE_SEPARATOR);
		fw.write(Constants.LINE_SEPARATOR);
		// 写入文件
		fw.write(content);
		// 写入空行
		fw.write(Constants.LINE_SEPARATOR);
		fw.write(Constants.LINE_SEPARATOR);
		fw.flush();
		nCount++;
	}
}
