/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.cipher;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class BangbangCipher {
    private static final String DES = "DES";
    private static final String RSA = "RSA";
    public static final String MD5 = "MD5";
    public static final String SHA_1 = "SHA-1";
    public static final String SHA1withRSA = "SHA1withRSA";

    public static byte[] encryptDES(byte[] rowData, byte[] rawKeyData) throws Exception {
        DESKeySpec dks = new DESKeySpec(rawKeyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey key = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        byte[] biv = new byte[8];
        for (int i = 0; i < 8 && i < rawKeyData.length; ++i) {
            biv[i] = rawKeyData[i];
        }
        IvParameterSpec iv = new IvParameterSpec(biv);
        cipher.init(1, (Key)key, iv);
        return cipher.doFinal(rowData);
    }

    public static byte[] decryptDES(byte[] encryptData, byte[] rawKeyData) throws Exception {
        DESKeySpec dks = new DESKeySpec(rawKeyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey key = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        byte[] biv = new byte[8];
        for (int i = 0; i < 8 && i < rawKeyData.length; ++i) {
            biv[i] = rawKeyData[i];
        }
        IvParameterSpec iv = new IvParameterSpec(biv);
        cipher.init(2, (Key)key, iv);
        return cipher.doFinal(encryptData);
    }

    public static KeyPair getRSAKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(RSA);
        keyPairGen.initialize(1024);
        return keyPairGen.generateKeyPair();
    }

    public static PublicKey recoverRSAPublicKey(BigInteger modulus, BigInteger publicExponent) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFac = KeyFactory.getInstance(RSA);
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
        return keyFac.generatePublic(pubKeySpec);
    }

    public static PrivateKey recoverRSAPrivateKey(BigInteger modulus, BigInteger privateExponent) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFac = KeyFactory.getInstance(RSA);
        RSAPrivateKeySpec priKeySpec = new RSAPrivateKeySpec(modulus, privateExponent);
        return keyFac.generatePrivate(priKeySpec);
    }

    public static byte[] encryptRSA(byte[] rowData, PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, publicKey);
        return cipher.doFinal(rowData);
    }

    public static byte[] decryptRSA(byte[] encryptData, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, privateKey);
        return cipher.doFinal(encryptData);
    }

    public static byte[] sign(PrivateKey privateKey, byte[] data, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] result = null;
        Signature st = Signature.getInstance(algorithm);
        st.initSign(privateKey);
        st.update(data);
        result = st.sign();
        return result;
    }

    public static boolean verifySign(PublicKey publicKey, byte[] srcData, byte[] signData, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature st = Signature.getInstance(algorithm);
        st.initVerify(publicKey);
        st.update(srcData);
        return st.verify(signData);
    }

    public static byte[] digest(byte[] bts, String algorithm) {
        if (bts == null) {
            bts = new byte[]{};
        }
        byte[] byEncrypt = null;
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(bts);
            byEncrypt = md.digest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byEncrypt;
    }

    public static String byte2hex(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int n = data[i] & 0xFF;
            if (n < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(n));
        }
        return sb.toString();
    }

    public static byte[] hex2byte(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() % 2 == 1) {
            return null;
        }
        int nLen = value.length() / 2;
        byte[] bts = new byte[nLen];
        try {
            for (int i = 0; i < nLen; ++i) {
                String s = value.substring(i * 2, i * 2 + 2);
                int n = Integer.parseInt(s, 16);
                bts[i] = (byte)(n & 0xFF);
            }
        }
        catch (Exception ex) {
            return null;
        }
        return bts;
    }
}

