/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import team.bangbang.common.config.NacosConfigReader;

public final class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static String config_file = "application";
    private static Properties prop = null;
    private static boolean loaded = false;
    private static String activeProfile = null;

    private Config() {
    }

    private static void initialize() {
        NacosConfigReader ncr;
        Map<String, String> mpConfig;
        String addrs;
        prop = new Properties();
        Config.read("bootstrap");
        Config.read(config_file);
        String profile = System.getenv("SPRING_PROFILES_ACTIVE");
        if (profile == null || profile.trim().length() == 0) {
            profile = System.getProperty("spring.profiles.active");
        }
        if (profile == null || profile.trim().length() == 0) {
            profile = prop.getProperty("spring.profiles.active");
        }
        if (profile != null && profile.trim().length() > 0) {
            activeProfile = profile.trim();
            Config.read(config_file + "-" + profile.trim());
        }
        if ((addrs = prop.getProperty("spring.cloud.nacos.config.server-addr")) != null && addrs.trim().length() > 0 && (mpConfig = (ncr = new NacosConfigReader(prop)).readConfig()) != null && !mpConfig.isEmpty()) {
            prop.putAll(mpConfig);
        }
        loaded = true;
    }

    public static void refresh() {
        prop = null;
        loaded = false;
    }

    public static String getProperty(String key) {
        if (!loaded) {
            Config.initialize();
        }
        return prop.getProperty(key);
    }

    public static Enumeration<String> keys() {
        if (!loaded) {
            Config.initialize();
        }
        return new Enumeration<String>(){
            Enumeration<Object> keys = Config.access$000().keys();

            @Override
            public boolean hasMoreElements() {
                return this.keys.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return (String)this.keys.nextElement();
            }
        };
    }

    public static String getActiveProfile() {
        if (!loaded) {
            Config.initialize();
        }
        if (activeProfile == null) {
            activeProfile = "";
        }
        return activeProfile;
    }

    private static void read(String fileName) {
        boolean bl = Config.readProperties(fileName + ".properties");
        if (bl) {
            return;
        }
        bl = Config.readYml(fileName + ".yml");
        if (bl) {
            return;
        }
        bl = Config.readYml(fileName + ".yaml");
        if (bl) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readProperties(String fileName) {
        InputStream is = null;
        File f = Config.getExternalFile(fileName);
        if (f != null) {
            try {
                is = new FileInputStream(f);
                prop.load(is);
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                logger.info("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 " + fileName + " \u5931\u8d25\uff0c\u5ffd\u7565\u8bfb\u53d6");
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/" + fileName);
            prop.load(is);
            boolean e = true;
            return e;
        }
        catch (Exception ex) {
            logger.info("\u672a\u53d1\u73b0\u914d\u7f6e\u6587\u4ef6 classpath://config/" + fileName + "\uff0c\u5ffd\u7565\u8bfb\u53d6");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            prop.load(is);
            boolean e = true;
            return e;
        }
        catch (Exception ex) {
            logger.info("\u672a\u53d1\u73b0\u914d\u7f6e\u6587\u4ef6 classpath://" + fileName + "\uff0c\u5ffd\u7565\u8bfb\u53d6");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static File getExternalFile(String fileName) {
        String path1;
        File f;
        String path = System.getProperty("user.dir");
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        if ((f = new File(path1 = path + "config" + File.separator + fileName)).exists()) {
            return f;
        }
        String path2 = path + fileName;
        f = new File(path2);
        if (f.exists()) {
            return f;
        }
        return f.exists() ? f : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readYml(String fileName) {
        InputStream is = null;
        Map m = null;
        Yaml yaml = new Yaml();
        boolean loaded = false;
        File f = Config.getExternalFile(fileName);
        if (f != null && f.exists()) {
            try {
                is = new FileInputStream(f);
                m = (Map)yaml.load(is);
                loaded = true;
            }
            catch (Exception ex) {
                logger.info("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 " + fileName + " \u5931\u8d25\uff0c\u5ffd\u7565\u8bfb\u53d6");
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!loaded) {
            try {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/" + fileName);
                if (is != null) {
                    m = (Map)yaml.load(is);
                    loaded = true;
                }
            }
            catch (Exception ex) {
                logger.info("\u672a\u53d1\u73b0\u914d\u7f6e\u6587\u4ef6 classpath://config/" + fileName + "\uff0c\u5ffd\u7565\u8bfb\u53d6");
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!loaded) {
            try {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
                if (is != null) {
                    m = (Map)yaml.load(is);
                    loaded = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.info("\u672a\u53d1\u73b0\u914d\u7f6e\u6587\u4ef6 classpath://" + fileName + "\uff0c\u5ffd\u7565\u8bfb\u53d6");
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Config.loadFromMap(m, "");
        return true;
    }

    static void loadFromMap(Map m, String prefix) {
        if (m == null || m.isEmpty()) {
            return;
        }
        for (Object key : m.keySet()) {
            Object value = m.get(key);
            String sk = String.valueOf(key).trim();
            String string = sk = prefix == null || prefix.trim().length() == 0 ? sk : prefix.trim() + "." + sk;
            if (value == null) continue;
            if (value instanceof Map) {
                Config.loadFromMap((Map)value, sk);
                continue;
            }
            prop.put(sk, String.valueOf(value).trim());
        }
    }

    static /* synthetic */ Properties access$000() {
        return prop;
    }
}

