/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.config;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import team.bangbang.common.config.Config;
import team.bangbang.common.net.http.HttpClient;

public class NacosConfigReader {
    private static final Logger logger = LoggerFactory.getLogger(NacosConfigReader.class);
    private static HttpClient hc = new HttpClient();
    private String addrs = null;
    private String namespace = null;
    private String group = null;
    private String dataId = null;
    private String extension = null;

    public NacosConfigReader(Properties prop) {
        this.addrs = prop.getProperty("spring.cloud.nacos.config.server-addr");
        this.namespace = prop.getProperty("spring.cloud.nacos.config.namespace");
        this.group = prop.getProperty("spring.cloud.nacos.config.group");
        if (this.group == null || this.group.trim().length() == 0) {
            this.group = "DEFAULT_GROUP";
        }
        this.dataId = prop.getProperty("spring.application.name");
        this.extension = prop.getProperty("spring.cloud.nacos.config.file-extension");
    }

    public Map<String, String> readConfig() {
        HashMap<String, String> mp = new HashMap<String, String>();
        if (this.addrs == null || this.addrs.trim().length() == 0) {
            return mp;
        }
        String url = this.getApiUrl();
        if (url == null || url.trim().length() == 0) {
            return mp;
        }
        Map<String, String> config = this.readConfigByApi(url);
        return config;
    }

    private String getApiUrl() {
        String addr;
        int index = this.addrs != null ? this.addrs.indexOf(",") : -1;
        String string = addr = index >= 0 ? this.addrs.substring(0, index).trim() : this.addrs;
        if (addr == null || addr.length() == 0) {
            return null;
        }
        String url = "http://" + addr + "/nacos/v1/cs/configs?";
        url = url + "tenant=" + this.namespace;
        url = url + "&dataId=" + this.dataId + "." + this.extension;
        url = url + "&group=" + this.group;
        return url;
    }

    private Map<String, String> readConfigByApi(String url) {
        String content = null;
        try {
            content = hc.get(url).toString();
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42nacos\u914d\u7f6e\u4e2d\u5fc3\u7684API\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a" + url);
            logger.error(e.getMessage());
        }
        if (content == null || content.trim().length() == 0) {
            return null;
        }
        try {
            if ("yml".equalsIgnoreCase(this.extension) || "yaml".equalsIgnoreCase(this.extension)) {
                Yaml yaml = new Yaml();
                Map m = (Map)yaml.load(content);
                Config.loadFromMap(m, "");
                return m;
            }
            if ("properties".equalsIgnoreCase(this.extension)) {
                return this.loadPropertiesFromString(content);
            }
            logger.info("\u672a\u6307\u5b9a${spring.cloud.nacos.config.file-extension}\uff0c\u4f7f\u7528properties\u683c\u5f0f\u52a0\u8f7d\u914d\u7f6e...");
            return this.loadPropertiesFromString(content);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790nacos\u914d\u7f6e\u4e2d\u5fc3\u7684\u914d\u7f6e\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            return null;
        }
    }

    private Map<String, String> loadPropertiesFromString(String content) {
        HashMap<String, String> m = new HashMap<String, String>();
        Properties prop = new Properties();
        try {
            prop.load(new StringReader(content));
            for (Object key : prop.keySet()) {
                String value = prop.getProperty((String)key);
                m.put((String)key, value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return m;
    }
}

