/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.data;

import java.io.Serializable;
import team.bangbang.common.data.DataSort;

public class Pagination
implements Serializable {
    private static final long serialVersionUID = -6017541488933958773L;
    private int nPageNo = 1;
    private int nRecordCount = 0;
    private int pageSize = 0;
    private DataSort dataSort = new DataSort();

    public void setMaxResults(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageCount() {
        int nPageCount = this.getRecordCount() / this.getMaxResults();
        if (this.getRecordCount() % this.getMaxResults() > 0) {
            ++nPageCount;
        }
        if (nPageCount == 0) {
            nPageCount = 1;
        }
        return nPageCount;
    }

    public int getStartPosition() {
        return (this.getPageNo() - 1) * this.getMaxResults();
    }

    public int getMaxResults() {
        return this.pageSize > 0 ? this.pageSize : 20;
    }

    public int getPageNo() {
        if (this.nPageNo < 1) {
            this.nPageNo = 1;
            return 1;
        }
        if (this.nPageNo > this.getPageCount()) {
            this.nPageNo = this.getPageCount();
        }
        return this.nPageNo;
    }

    public void setPageNo(int pageNo) {
        this.nPageNo = pageNo;
    }

    public int getRecordCount() {
        return this.nRecordCount;
    }

    public void setRecordCount(int recordCount) {
        this.nRecordCount = recordCount;
    }

    public DataSort getDataSort() {
        return this.dataSort;
    }

    public void setDataSort(DataSort dataSort) {
        this.dataSort = dataSort;
    }
}

