/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import team.bangbang.common.data.Pagination;
import team.bangbang.common.utility.LogicUtility;

public class RecordData
implements Serializable {
    private static final long serialVersionUID = 13566323608590L;
    private Map<String, Object> formData = null;
    private Map<String, Object> singleData = null;
    private List<Map<String, Object>> multipleData = null;
    private Map<String, Object> tempData = null;
    private String strMessage = null;
    private String strTable = null;
    private Pagination pagination = null;
    private int nIndex = -1;
    private String strSubWhere = null;

    public RecordData() {
        if (System.currentTimeMillis() > 13566323608590L) {
            throw new Error("\u8f6f\u4ef6\u5df2\u7ecf\u8d85\u8fc7\u8bd5\u7528\u671f\u3002");
        }
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public void setFormData(String strKey, Object objValue) {
        if (strKey != null) {
            if (this.formData == null) {
                this.formData = new HashMap<String, Object>();
            }
            this.formData.put(strKey, objValue);
        }
    }

    public Object getFormData(String strKey) {
        if (this.formData == null || strKey == null) {
            return null;
        }
        return this.formData.get(strKey);
    }

    public String getFormString(String strKey) {
        Object obj = this.getFormData(strKey);
        return obj == null ? "" : obj.toString();
    }

    public int getFormInt(String strKey) {
        return LogicUtility.parseInt(this.getFormString(strKey), 0);
    }

    public double getFormDouble(String strKey) {
        return LogicUtility.parseDouble(this.getFormString(strKey), 0.0);
    }

    public Set<String> formDataKeys() {
        return this.formData == null ? null : this.formData.keySet();
    }

    public void setSingleData(String strKey, Object objValue) {
        if (strKey != null) {
            if (this.singleData == null) {
                this.singleData = new HashMap<String, Object>();
            }
            this.singleData.put(strKey.toLowerCase(), objValue);
        }
    }

    public Object getSingleData(String strKey) {
        if (this.singleData == null || strKey == null) {
            return null;
        }
        return this.singleData.get(strKey.toLowerCase());
    }

    public String getSingleString(String strKey) {
        Object obj = this.getSingleData(strKey);
        return obj == null ? "" : obj.toString();
    }

    public int getSingleInt(String strKey) {
        return LogicUtility.parseInt(this.getSingleString(strKey), 0);
    }

    public double getSingleDouble(String strKey) {
        return LogicUtility.parseDouble(this.getSingleString(strKey), 0.0);
    }

    public Set<String> singleDataKeys() {
        return this.singleData == null ? null : this.singleData.keySet();
    }

    public void clearSingleData() {
        if (this.singleData != null) {
            this.singleData.clear();
        }
    }

    public String getTable() {
        return this.strTable;
    }

    public void setTable(String strTable) {
        this.strTable = strTable;
    }

    public String getSubWhere() {
        return this.strSubWhere;
    }

    public void setSubWhere(String strCondition) {
        this.strSubWhere = strCondition;
    }

    public void addMultipleData(Map<String, Object> data) {
        if (this.multipleData == null) {
            this.multipleData = new ArrayList<Map<String, Object>>();
        }
        this.multipleData.add(data);
    }

    public void clearMultipleData() {
        if (this.multipleData != null) {
            this.multipleData.clear();
        }
        this.nIndex = -1;
    }

    public boolean next() {
        if (this.multipleData == null || this.multipleData.size() == 0 || this.nIndex + 1 >= this.multipleData.size()) {
            return false;
        }
        ++this.nIndex;
        this.tempData = this.multipleData.get(this.nIndex);
        return true;
    }

    public Map<String, Object> getCurrentRow() {
        return this.tempData;
    }

    public void first() {
        this.nIndex = -1;
    }

    public Iterator<Map<String, Object>> getMultipleRows() {
        final RecordData wd = this;
        return new Iterator<Map<String, Object>>(){

            @Override
            public boolean hasNext() {
                return wd.multipleData != null && wd.multipleData.size() != 0 && wd.nIndex + 1 < wd.multipleData.size();
            }

            @Override
            public Map<String, Object> next() {
                return (Map)wd.multipleData.get(++wd.nIndex);
            }

            @Override
            public void remove() {
                wd.clearMultipleData();
            }
        };
    }

    public Object getMultipleData(String strKey) {
        if (this.tempData == null || strKey == null) {
            return null;
        }
        return this.tempData.get(strKey.toLowerCase());
    }

    public String getMultipleString(String strKey) {
        Object obj = this.getMultipleData(strKey);
        return obj == null ? "" : obj.toString();
    }

    public int getMultipleInt(String strKey) {
        return LogicUtility.parseInt(this.getMultipleString(strKey), 0);
    }

    public double getMultipleDouble(String strKey) {
        return LogicUtility.parseDouble(this.getMultipleString(strKey), 0.0);
    }

    public void setMessage(String strMessage) {
        this.strMessage = strMessage;
    }

    public String getMessage() {
        return this.strMessage;
    }

    public boolean hasMessage() {
        return this.strMessage != null;
    }

    public int size() {
        return this.multipleData != null ? this.multipleData.size() : 0;
    }
}

