/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.exp;

import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import team.bangbang.common.CommonMPI;
import team.bangbang.common.exception.BizException;
import team.bangbang.common.exp.Exporter;
import team.bangbang.common.file.ExcelWriter;

public abstract class RecordExporter<T>
extends Exporter {
    private Object accountId = null;
    private List<T> recordList = null;
    private String excelFileName = null;

    public RecordExporter(Object accountId, List<T> recordList, String excelFileName) {
        this.accountId = accountId;
        this.recordList = recordList;
        this.excelFileName = excelFileName;
    }

    @Override
    public String[] export() throws BizException {
        if (this.recordList == null || this.titles == null || this.fields == null) {
            throw new BizException("\u8bf7\u9996\u5148\u6267\u884c\u67e5\u8be2\uff0c\u7136\u540e\u518d\u6267\u884c\u5bfc\u51fa\uff01");
        }
        ExcelWriter ew = null;
        try {
            if (this.titles.length != this.fields.length) {
                throw new BizException("\u6807\u9898\u6570\u91cf\uff08" + this.titles.length + "\uff09\u4e0e\u5bf9\u5e94\u7684\u5b57\u6bb5\u6570\u91cf\uff08" + this.fields.length + "\uff09\u4e0d\u4e00\u81f4\uff01");
            }
            String tempFile = CommonMPI.getAccountTemporaryFile(this.accountId);
            ew = new ExcelWriter(tempFile);
            int count = 0;
            for (int i = 0; this.recordList != null && i < this.recordList.size(); ++i) {
                if (count % 60000 == 0) {
                    int nIndex = count / 60000;
                    ew.createSheet("\u6570\u636e " + (nIndex + 1));
                    ew.toRow(1);
                    ew.toColumn(1);
                    Dimension off1 = ew.getOffset();
                    for (int j = 0; j < this.titles.length; ++j) {
                        if (!this.selectedFields.contains(this.fields[j])) continue;
                        ew.writeCell(this.titles[j]);
                    }
                    Dimension off2 = ew.getOffset();
                    ew.setHeader(off1, off2);
                }
                ew.nextRow();
                ew.toColumn(1);
                T t = this.recordList.get(i);
                for (int j = 0; j < this.fields.length; ++j) {
                    if (!this.selectedFields.contains(this.fields[j])) continue;
                    Object s = this.fields[j] == null || this.fields[j].trim().length() == 0 ? null : this.getObject(t, this.fields[j]);
                    ew.writeCell(s);
                }
                ++count;
            }
        }
        catch (Exception e) {
            throw new BizException(e);
        }
        finally {
            try {
                if (ew != null) {
                    ew.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String s = this.excelFileName + ".xls";
        try {
            s = URLEncoder.encode(s, "UTF-8");
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] result = new String[]{"Temp/" + this.accountId + ".dat", s};
        return result;
    }

    protected abstract Object getObject(T var1, String var2);
}

