/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.ss.usermodel.CellType;
import team.bangbang.common.file.ExcelColumn;
import team.bangbang.common.file.ExcelReader;

public class ExcelDataChecker {
    private String excelFile = null;
    private int sheetIndex = 0;
    private Class<?> clazz = null;
    private int fromRow = 0;
    private ExcelReader er = null;
    private List<ExcelColumn> ecList = new ArrayList<ExcelColumn>();

    public ExcelDataChecker(String excelFile, int sheetIndex, Class<?> clazz, int fromRow) {
        this.excelFile = excelFile;
        this.sheetIndex = sheetIndex;
        this.clazz = clazz;
        this.fromRow = fromRow;
    }

    public List<String> check() {
        ArrayList<String> msgs = new ArrayList<String>();
        try {
            this.checkParameter(msgs);
            if (!msgs.isEmpty()) {
                ArrayList<String> arrayList = msgs;
                return arrayList;
            }
            this.checkData(msgs);
        }
        catch (Exception ex) {
            msgs.add(ex.getMessage());
        }
        finally {
            if (this.er != null) {
                this.er.close();
            }
        }
        return msgs;
    }

    private void checkParameter(List<String> msgs) {
        try {
            this.er = new ExcelReader(this.excelFile);
        }
        catch (Exception e) {
            msgs.add("\u8bfbExcel\u6587\u4ef6\u9047\u5230\u95ee\u9898\uff0c\u8bf7\u786e\u8ba4Excel\u6587\u4ef6\u662f\u5426\u5b58\u5728\uff08" + this.excelFile + "\uff09");
            return;
        }
        try {
            this.er.setSheetIndex(this.sheetIndex);
        }
        catch (Exception e) {
            msgs.add("\u6307\u5b9a\u7684\u5de5\u4f5c\u7c3f\u4e0d\u5b58\u5728\uff08\u5e8f\u53f7\uff1a" + this.sheetIndex + "\uff09");
            return;
        }
        try {
            boolean bl = this.er.toRow(this.fromRow);
            if (!bl) {
                msgs.add("\u6307\u5b9a\u7684\u6570\u636e\u884c\u4e0d\u5b58\u5728\uff08\u5e8f\u53f7\uff1a" + this.fromRow + "\uff09");
                return;
            }
        }
        catch (Exception e) {
            msgs.add("\u6307\u5b9a\u7684\u6570\u636e\u884c\u4e0d\u5b58\u5728\uff08\u5e8f\u53f7\uff1a" + this.fromRow + "\uff09");
            return;
        }
        Field[] fs = this.clazz.getDeclaredFields();
        if (fs == null || fs.length == 0) {
            msgs.add("\u6570\u636e\u89c4\u5219\u5b9a\u4e49\u7c7b\u672a\u5305\u542b\u4efb\u4f55\u5c5e\u6027\uff08\u5e8f\u53f7\uff1a" + this.clazz.getName() + "\uff09");
            return;
        }
        this.ecList.clear();
        Class<ExcelColumn> c2 = ExcelColumn.class;
        for (Field f : fs) {
            ExcelColumn ec = f.getAnnotation(c2);
            if (ec == null) continue;
            this.ecList.add(ec);
        }
        if (this.ecList.isEmpty()) {
            msgs.add("\u6570\u636e\u89c4\u5219\u5b9a\u4e49\u7c7b\u672a\u5305\u542bExcelColumn\u6ce8\u89e3\uff08\u5e8f\u53f7\uff1a" + this.clazz.getName() + "\uff09");
        }
        this.ecList.sort(new Comparator<ExcelColumn>(){

            @Override
            public int compare(ExcelColumn o1, ExcelColumn o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.index() < o2.index()) {
                    return -1;
                }
                if (o1.index() == o2.index()) {
                    return 0;
                }
                return 1;
            }
        });
    }

    private void checkData(List<String> msgs) {
        this.er.toRow(this.fromRow);
        int lineNo = this.fromRow + 1;
        while (true) {
            this.checkDataLine(lineNo, msgs);
            boolean bl = this.er.nextRow();
            if (!bl) break;
            ++lineNo;
        }
    }

    private void checkDataLine(int lineNo, List<String> msgs) {
        for (int i = 0; i < this.ecList.size(); ++i) {
            double d;
            String s;
            ExcelColumn ec = this.ecList.get(i);
            this.er.toColumn(ec.index());
            CellType ct = ec.type();
            String typeName = this.getCellTypeName(ct);
            Object value = this.er.readCell();
            String string = s = value == null ? null : String.valueOf(value);
            if (s == null || s.trim().length() == 0) {
                if (!ec.required()) continue;
                msgs.add("\uff08\u884c\uff1a" + lineNo + "\uff0c\u5217\uff1a" + (ec.index() + 1) + "\uff09\u8981\u6c42\u5fc5\u586b");
                continue;
            }
            boolean okType = this.checkType(ct, value);
            if (!okType) {
                msgs.add("\uff08\u884c\uff1a" + lineNo + "\uff0c\u5217\uff1a" + (ec.index() + 1) + "\uff09\u7c7b\u578b\u5fc5\u987b\u662f" + typeName);
            }
            if (!(value instanceof Double) || !((d = ((Double)value).doubleValue()) < (double)ec.min()) && !(d > (double)ec.max())) continue;
            msgs.add("\uff08\u884c\uff1a" + lineNo + "\uff0c\u5217\uff1a" + (ec.index() + 1) + "\uff09\u6570\u503c\u5fc5\u987b\u5728 [" + ec.min() + ", " + ec.max() + "] \u8303\u56f4\u5185");
        }
    }

    private boolean checkType(CellType ct, Object value) {
        if (ct == CellType.BOOLEAN) {
            return value instanceof Boolean;
        }
        if (ct == CellType.NUMERIC) {
            return value instanceof Double;
        }
        if (ct == CellType.STRING) {
            return value instanceof String;
        }
        return true;
    }

    private String getCellTypeName(CellType ct) {
        if (ct == CellType.BLANK) {
            return "\u7a7a\u767d";
        }
        if (ct == CellType.BOOLEAN) {
            return "\u5e03\u5c14\u578b";
        }
        if (ct == CellType.ERROR) {
            return "\u9519\u8bef\u7c7b\u578b";
        }
        if (ct == CellType.FORMULA) {
            return "\u516c\u5f0f";
        }
        if (ct == CellType.NUMERIC) {
            return "\u6570\u503c";
        }
        if (ct == CellType.STRING) {
            return "\u5b57\u7b26";
        }
        return "\u4e0d\u660e\u7c7b\u578b";
    }
}

