/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@Deprecated
public class ExcelReader {
    private InputStream is = null;
    private Workbook workbook = null;
    private Sheet sheet = null;
    private int rowNo = 0;
    private Row currentRow = null;
    private int columnNo = 0;
    private int rowCount = 0;

    public ExcelReader(String excelFile) throws IOException {
        if (excelFile.toLowerCase().startsWith("http://") || excelFile.toLowerCase().startsWith("https://")) {
            URL url = new URL(excelFile);
            this.is = url.openStream();
            this.workbook = new HSSFWorkbook();
            this.workbook = excelFile.trim().toLowerCase().endsWith(".xlsx") ? new XSSFWorkbook(this.is) : new HSSFWorkbook(this.is);
        } else {
            this.is = new FileInputStream(excelFile);
            this.workbook = excelFile.trim().toLowerCase().endsWith(".xlsx") ? new XSSFWorkbook(this.is) : new HSSFWorkbook(this.is);
        }
    }

    public ExcelReader(InputStream is) throws IOException {
        this.is = is;
        this.workbook = new HSSFWorkbook(is);
    }

    public void setSheetIndex(int nIndex) {
        this.sheet = this.workbook.getSheetAt(nIndex);
        this.rowNo = 0;
        this.columnNo = 0;
        this.rowCount = this.sheet.getLastRowNum() + 1;
        this.currentRow = this.sheet.getRow(this.rowNo);
    }

    public boolean nextRow() {
        boolean hasRow;
        ++this.rowNo;
        this.columnNo = 0;
        boolean bl = hasRow = this.rowNo < this.rowCount;
        if (hasRow) {
            this.currentRow = this.sheet.getRow(this.rowNo);
        }
        return hasRow;
    }

    public boolean toRow(int nRow) {
        boolean hasRow;
        this.rowNo = nRow;
        this.columnNo = 0;
        boolean bl = hasRow = this.rowNo < this.rowCount;
        if (hasRow) {
            this.currentRow = this.sheet.getRow(this.rowNo);
        }
        return hasRow;
    }

    public void toColumn(int nColumn) {
        this.columnNo = nColumn;
    }

    public Object readCell() {
        Cell c;
        Object obj;
        if (this.sheet == null || this.currentRow == null) {
            return null;
        }
        if (this.rowNo >= this.rowCount) {
            return null;
        }
        short columnCount = this.currentRow.getLastCellNum();
        if (this.columnNo > columnCount) {
            return null;
        }
        return (obj = this.readCell(c = this.currentRow.getCell(this.columnNo++))) != null ? obj : "";
    }

    private Object readCell(Cell c) {
        if (c == null) {
            return null;
        }
        CellType ct = c.getCellTypeEnum();
        if (ct == CellType.BLANK) {
            return "";
        }
        if (ct == CellType.BOOLEAN) {
            return c.getBooleanCellValue();
        }
        if (ct == CellType.ERROR) {
            return "";
        }
        if (ct == CellType.FORMULA) {
            return c.getCellFormula();
        }
        if (ct == CellType.NUMERIC) {
            return c.getNumericCellValue();
        }
        if (ct == CellType.STRING) {
            return c.getStringCellValue();
        }
        return null;
    }

    public String readCell(int column, int row) {
        short columnCount;
        boolean hasRow;
        if (this.sheet == null) {
            return null;
        }
        if (row >= this.rowCount) {
            return null;
        }
        boolean bl = hasRow = this.rowNo <= this.rowCount;
        if (hasRow) {
            this.currentRow = this.sheet.getRow(this.rowNo);
        }
        if (column >= (columnCount = this.currentRow.getLastCellNum())) {
            return null;
        }
        return this.currentRow.getCell(column).getStringCellValue();
    }

    public int getRowCount() {
        if (this.sheet == null) {
            return -1;
        }
        return this.rowCount;
    }

    public void close() {
        try {
            this.workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

