/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import team.bangbang.common.file.FileUtil;

@Deprecated
public class ExcelWriter {
    private OutputStream os = null;
    private Workbook workbook = null;
    private Sheet sheet = null;
    private int rowNo = 0;
    private Row currentRow = null;
    private int columnNo = 0;
    private boolean hasWrite = false;

    public ExcelWriter(String excelFile) {
        this.workbook = excelFile.trim().toLowerCase().endsWith(".xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        try {
            this.os = new FileOutputStream(excelFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelWriter(String templateFile, String excelFile) {
        if (templateFile != null && templateFile.trim().length() > 0) {
            InputStream is = null;
            try {
                String ext1 = FileUtil.getFileExtension(templateFile);
                String ext2 = FileUtil.getFileExtension(templateFile);
                if (!ext1.equalsIgnoreCase(ext2)) {
                    throw new Exception("\u6a21\u677fExcel\u6587\u4ef6\u6269\u5c55\u540d\u548c\u76ee\u6807Excel\u6269\u5c55\u540d\u5fc5\u987b\u4e00\u81f4\uff01");
                }
                is = new FileInputStream(templateFile);
                this.workbook = excelFile.trim().toLowerCase().endsWith(".xlsx") ? new XSSFWorkbook(is) : new HSSFWorkbook(is);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.workbook == null) {
            this.workbook = excelFile.trim().toLowerCase().endsWith(".xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        }
        try {
            this.os = new FileOutputStream(excelFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void createSheet(String strName) {
        this.sheet = this.workbook.createSheet(strName);
        this.workbook.setActiveSheet(this.workbook.getSheetIndex(strName));
        this.rowNo = 0;
        this.columnNo = 0;
        boolean hasRow = this.rowNo < this.sheet.getLastRowNum();
        this.currentRow = hasRow ? this.sheet.getRow(this.rowNo) : this.sheet.createRow(this.rowNo);
        this.hasWrite = false;
    }

    public void createSheet(String strName, int index) {
        this.createSheet(strName);
        this.workbook.setSheetOrder(strName, index);
    }

    public void setSheetIndex(int nIndex) {
        this.sheet = this.workbook.getSheetAt(nIndex);
        this.rowNo = 0;
        this.columnNo = 0;
        boolean hasRow = this.rowNo < this.sheet.getLastRowNum();
        this.currentRow = hasRow ? this.sheet.getRow(this.rowNo) : this.sheet.createRow(this.rowNo);
        this.hasWrite = false;
    }

    public boolean nextRow() {
        ++this.rowNo;
        this.columnNo = 0;
        boolean hasRow = this.rowNo < this.sheet.getLastRowNum();
        this.currentRow = hasRow ? this.sheet.getRow(this.rowNo) : this.sheet.createRow(this.rowNo);
        this.hasWrite = false;
        return true;
    }

    public void toRow(int nRow) {
        this.rowNo = nRow;
        this.columnNo = 0;
        boolean hasRow = this.rowNo < this.sheet.getLastRowNum();
        this.currentRow = hasRow ? this.sheet.getRow(this.rowNo) : this.sheet.createRow(this.rowNo);
        this.hasWrite = false;
    }

    public void toColumn(int nColumn) {
        this.columnNo = nColumn;
        boolean hasRow = this.rowNo < this.sheet.getLastRowNum();
        this.currentRow = hasRow ? this.sheet.getRow(this.rowNo) : this.sheet.createRow(this.rowNo);
        this.hasWrite = false;
    }

    public Dimension getOffset() {
        return new Dimension(this.hasWrite ? this.columnNo - 1 : this.columnNo, this.rowNo);
    }

    public void merge(Dimension offset1, Dimension offset2) {
        CellRangeAddress region = new CellRangeAddress(offset1.height, offset2.height, offset1.width, offset2.width);
        this.sheet.addMergedRegion(region);
    }

    public void writeCell(Object content) {
        if (content == null) {
            content = "";
        }
        this.currentRow.createCell(this.columnNo++).setCellValue(content.toString());
        this.hasWrite = true;
    }

    public void setHeader(Dimension offset1, Dimension offset2) {
        int x1 = offset1.width;
        int y1 = offset1.height;
        int x2 = offset2.width;
        int y2 = offset2.height;
        Font f = this.workbook.createFont();
        f.setBold(true);
        f.setColor(IndexedColors.WHITE.index);
        for (int i = y1; i <= y2; ++i) {
            for (int j = x1; j <= x2; ++j) {
                CellStyle cs = this.workbook.createCellStyle();
                cs.setFont(f);
                Cell c = this.sheet.getRow(i).getCell(j);
                if (c == null) {
                    this.sheet.getRow(i).createCell(j);
                    c = this.sheet.getRow(i).getCell(j);
                }
                c.setCellStyle(cs);
                cs.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
                cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                if (i == y1) {
                    cs.setBorderTop(BorderStyle.THIN);
                    cs.setTopBorderColor(IndexedColors.LIGHT_BLUE.index);
                } else {
                    cs.setBorderTop(BorderStyle.DOTTED);
                    cs.setTopBorderColor(IndexedColors.DARK_BLUE.index);
                }
                if (j == x2) {
                    cs.setBorderRight(BorderStyle.THIN);
                    cs.setRightBorderColor(IndexedColors.LIGHT_BLUE.index);
                } else {
                    cs.setBorderRight(BorderStyle.DOTTED);
                    cs.setRightBorderColor(IndexedColors.DARK_BLUE.index);
                }
                if (i == y2) {
                    cs.setBorderBottom(BorderStyle.THIN);
                    cs.setBottomBorderColor(IndexedColors.LIGHT_BLUE.index);
                } else {
                    cs.setBorderBottom(BorderStyle.DOTTED);
                    cs.setBottomBorderColor(IndexedColors.DARK_BLUE.index);
                }
                if (j == x1) {
                    cs.setBorderLeft(BorderStyle.THIN);
                    cs.setLeftBorderColor(IndexedColors.LIGHT_BLUE.index);
                } else {
                    cs.setBorderLeft(BorderStyle.DOTTED);
                    cs.setLeftBorderColor(IndexedColors.DARK_BLUE.index);
                }
                cs.setAlignment(HorizontalAlignment.CENTER);
                cs.setVerticalAlignment(VerticalAlignment.CENTER);
            }
        }
    }

    public void setFooter(Dimension offset1, Dimension offset2) {
        int x1 = offset1.width;
        int y1 = offset1.height;
        int x2 = offset2.width;
        int y2 = offset2.height;
        Font f = this.workbook.createFont();
        f.setBold(true);
        f.setColor(IndexedColors.DARK_RED.index);
        for (int i = y1; i <= y2; ++i) {
            for (int j = x1; j <= x2; ++j) {
                CellStyle cs = this.workbook.createCellStyle();
                cs.setFont(f);
                Cell c = this.sheet.getRow(i).getCell(j);
                if (c == null) {
                    this.sheet.getRow(i).createCell(j);
                    c = this.sheet.getRow(i).getCell(j);
                }
                c.setCellStyle(cs);
                cs.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
                cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                if (i == y1) {
                    cs.setBorderTop(BorderStyle.THIN);
                    cs.setTopBorderColor(IndexedColors.GREY_50_PERCENT.index);
                } else {
                    cs.setBorderTop(BorderStyle.DOTTED);
                    cs.setTopBorderColor(IndexedColors.GREY_80_PERCENT.index);
                }
                if (j == x2) {
                    cs.setBorderRight(BorderStyle.THIN);
                    cs.setRightBorderColor(IndexedColors.GREY_50_PERCENT.index);
                } else {
                    cs.setBorderRight(BorderStyle.DOTTED);
                    cs.setRightBorderColor(IndexedColors.GREY_80_PERCENT.index);
                }
                if (i == y2) {
                    cs.setBorderBottom(BorderStyle.THIN);
                    cs.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.index);
                } else {
                    cs.setBorderBottom(BorderStyle.DOTTED);
                    cs.setBottomBorderColor(IndexedColors.GREY_80_PERCENT.index);
                }
                if (j == x1) {
                    cs.setBorderLeft(BorderStyle.THIN);
                    cs.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.index);
                } else {
                    cs.setBorderLeft(BorderStyle.DOTTED);
                    cs.setLeftBorderColor(IndexedColors.GREY_80_PERCENT.index);
                }
                cs.setAlignment(HorizontalAlignment.CENTER);
                cs.setVerticalAlignment(VerticalAlignment.CENTER);
            }
        }
    }

    public void setBorder(Dimension offset1, Dimension offset2) {
        int x1 = offset1.width;
        int y1 = offset1.height;
        int x2 = offset2.width;
        int y2 = offset2.height;
        for (int i = y1; i <= y2; ++i) {
            for (int j = x1; j <= x2; ++j) {
                CellStyle cs = this.workbook.createCellStyle();
                Cell c = this.sheet.getRow(i).getCell(j);
                if (c == null) {
                    this.sheet.getRow(i).createCell(j);
                    c = this.sheet.getRow(i).getCell(j);
                }
                c.setCellStyle(cs);
                if (i == y1) {
                    cs.setBorderTop(BorderStyle.THIN);
                    cs.setTopBorderColor(IndexedColors.LIGHT_BLUE.index);
                } else {
                    cs.setBorderTop(BorderStyle.DOTTED);
                    cs.setTopBorderColor(IndexedColors.LIGHT_BLUE.index);
                }
                if (j == x2) {
                    cs.setBorderRight(BorderStyle.THIN);
                    cs.setRightBorderColor(IndexedColors.LIGHT_BLUE.index);
                } else {
                    cs.setBorderRight(BorderStyle.DOTTED);
                    cs.setRightBorderColor(IndexedColors.LIGHT_BLUE.index);
                }
                if (i == y2) {
                    cs.setBorderBottom(BorderStyle.THIN);
                    cs.setBottomBorderColor(IndexedColors.LIGHT_BLUE.index);
                } else {
                    cs.setBorderBottom(BorderStyle.DOTTED);
                    cs.setBottomBorderColor(IndexedColors.LIGHT_BLUE.index);
                }
                if (j == x1) {
                    cs.setBorderLeft(BorderStyle.THIN);
                    cs.setLeftBorderColor(IndexedColors.LIGHT_BLUE.index);
                    continue;
                }
                cs.setBorderLeft(BorderStyle.DOTTED);
                cs.setLeftBorderColor(IndexedColors.LIGHT_BLUE.index);
            }
        }
    }

    public void setAlignment(Dimension offset1, Dimension offset2, String align) {
        if (align == null) {
            return;
        }
        align = align.trim().toLowerCase();
        int x1 = offset1.width;
        int y1 = offset1.height;
        int x2 = offset2.width;
        int y2 = offset2.height;
        HorizontalAlignment ali = null;
        if ("left".equals(align)) {
            ali = HorizontalAlignment.LEFT;
        } else if ("center".equals(align)) {
            ali = HorizontalAlignment.CENTER;
        } else if ("centre".equals(align)) {
            ali = HorizontalAlignment.CENTER;
        } else if ("right".equals(align)) {
            ali = HorizontalAlignment.RIGHT;
        } else if ("justify".equals(align)) {
            ali = HorizontalAlignment.JUSTIFY;
        }
        VerticalAlignment val = null;
        if (ali == null) {
            if ("top".equals(align)) {
                val = VerticalAlignment.TOP;
            } else if ("middle".equals(align)) {
                val = VerticalAlignment.CENTER;
            } else if ("bottom".equals(align)) {
                val = VerticalAlignment.BOTTOM;
            }
            if (val == null) {
                return;
            }
        }
        CellStyle cs = this.workbook.createCellStyle();
        cs.setAlignment(ali);
        cs.setVerticalAlignment(val);
        for (int i = x1; i < x2; ++i) {
            for (int j = y1; j < y2; ++j) {
                CellStyle cs2 = this.sheet.getRow(i).getCell(j).getCellStyle();
                if (cs2 != null) {
                    cs2.setAlignment(ali);
                    cs2.setVerticalAlignment(val);
                    continue;
                }
                this.sheet.getRow(i).getCell(j).setCellStyle(cs);
            }
        }
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.sheet.setColumnWidth(columnIndex, width * 256);
    }

    public void setRowHeight(int rowIndex, int height) {
        this.sheet.getRow(rowIndex).setHeightInPoints((float)height);
    }

    public void close() {
        try {
            this.workbook.write(this.os);
        }
        catch (Exception ex) {
            try {
                this.workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

