/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileWriter {
    private File file = null;

    public FileWriter(String strFile) throws IOException {
        this.file = new File(strFile);
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
    }

    public FileWriter(File f) throws IOException {
        this.file = f;
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
    }

    public void writeString(String content, String charsetName) throws IOException {
        this.writeString(content, charsetName, false);
    }

    public void writeString(String content, String charsetName, boolean blAppend) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, blAppend), charsetName);
            writer.write(content);
        }
        catch (IOException iex) {
            throw iex;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void writeBytes(byte[] byContent) throws IOException {
        this.writeBytes(byContent, false);
    }

    public void writeBytes(byte[] byContent, boolean blAppend) throws IOException {
        FileOutputStream writer = null;
        try {
            writer = new FileOutputStream(this.file, blAppend);
            writer.write(byContent);
        }
        catch (IOException iex) {
            throw iex;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

