/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import team.bangbang.common.exception.BizException;
import team.bangbang.common.utility.LogicUtility;

public class ResourceLoader {
    public static InputStream getResourceAsStream(String resource) throws IOException {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = LogicUtility.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = LogicUtility.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new IOException(resource + " not found");
        }
        return stream;
    }

    public static InputStream getInputStream(Class<?> cls, String resourceFile) throws BizException {
        String pkg;
        String string = pkg = cls != null ? cls.getPackage().getName() : null;
        if (pkg != null && pkg.length() > 0) {
            resourceFile = pkg.replace('.', '/') + '/' + resourceFile;
        }
        resourceFile = resourceFile.replaceAll("^/+", "");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceFile);
        if (is == null) {
            throw new BizException("File (" + resourceFile + ") is not exist.");
        }
        return is;
    }

    public static String getPath(Class<?> cls, String resourceFile) throws BizException {
        URL url;
        String pkg = cls.getPackage().getName();
        if (pkg != null && pkg.length() > 0) {
            resourceFile = pkg.replace('.', '/') + '/' + resourceFile;
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource(resourceFile)) == null) {
            throw new BizException("File (" + resourceFile + ") is not exist.");
        }
        return url.getFile();
    }
}

