/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import team.bangbang.common.config.Config;
import team.bangbang.common.data.KeyValue;
import team.bangbang.common.utility.LogicUtility;

@WebFilter(filterName="DDosFilter", urlPatterns={"/ddos/*"})
public class DDosFilter
implements Filter {
    private static final String KEY_DDOS_IDENTITY = "KEY_DDOS_IDENTITY";
    private static final String KEY_DDOS_VISIT = "KEY_DDOS_VISIT";
    private static final boolean enable = Config.getProperty("filter.DDosFilter.enable") != null && Config.getProperty("filter.DDosFilter.enable").trim().equalsIgnoreCase("true");
    private String[] enter_uris = null;
    private String[] referer_prefixs = null;
    private int second_limit = 0;
    private int visit_limit = 0;
    private String deny_message = Config.getProperty("filter.DDosFilter.parameter.deny-message");
    private String s1 = Config.getProperty("filter.DDosFilter.parameter.enter-uri");
    private String s2 = Config.getProperty("filter.DDosFilter.parameter.second-limit");
    private String s3 = Config.getProperty("filter.DDosFilter.parameter.visit-limit");
    private String s4 = Config.getProperty("filter.DDosFilter.parameter.referer-prefix");

    public void init(FilterConfig argFilterConfig) throws ServletException {
        if (this.s1 != null && this.s1.trim().length() > 0) {
            this.s1 = this.s1.replace(',', ' ');
            this.enter_uris = this.s1.trim().split("\\s+");
        }
        if (this.s4 != null && this.s4.trim().length() > 0) {
            this.s4 = this.s4.replace(',', ' ');
            this.referer_prefixs = this.s4.trim().split("\\s+");
        }
        this.second_limit = LogicUtility.parseInt(this.s2, 0);
        this.visit_limit = LogicUtility.parseInt(this.s3, 0);
        this.deny_message = this.deny_message == null || this.deny_message.trim().length() == 0 ? "{errcode:174000, errcode:'Your are not welcome!'}" : this.deny_message.trim();
    }

    public void doFilter(ServletRequest argRequest, ServletResponse argResponse, FilterChain argChain) throws IOException, ServletException {
        String v2;
        if (!enable) {
            argChain.doFilter(argRequest, argResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)argRequest;
        HttpSession session = request.getSession(true);
        ArrayList<KeyValue> vRecords = (ArrayList<KeyValue>)session.getAttribute(KEY_DDOS_VISIT);
        if (vRecords == null) {
            vRecords = new ArrayList<KeyValue>();
            session.setAttribute(KEY_DDOS_VISIT, vRecords);
        }
        String ip = request.getRemoteHost();
        String strURI = request.getRequestURI().trim();
        if (this.isEnterUri(strURI = strURI.substring(request.getContextPath().length()))) {
            if (!this.canVisit(vRecords, ip)) {
                argResponse.getWriter().println(this.deny_message);
                return;
            }
            String v = session.getId() + ":" + request.getHeader("user-agent");
            session.setAttribute(KEY_DDOS_IDENTITY, (Object)v);
            argChain.doFilter(argRequest, argResponse);
            return;
        }
        String referer = request.getHeader("referer");
        if (!this.isValidReferer(referer)) {
            argResponse.getWriter().println(this.deny_message);
            return;
        }
        String v1 = session.getId() + ":" + request.getHeader("user-agent");
        if (!v1.equals(v2 = (String)session.getAttribute(KEY_DDOS_IDENTITY))) {
            argResponse.getWriter().println(this.deny_message);
            return;
        }
        if (!this.canVisit(vRecords, ip)) {
            argResponse.getWriter().println(this.deny_message);
            return;
        }
        argChain.doFilter(argRequest, argResponse);
    }

    private boolean isEnterUri(String strURI) {
        if (strURI == null || strURI.length() == 0 || this.enter_uris == null || this.enter_uris.length == 0) {
            return false;
        }
        for (String s : this.enter_uris) {
            if (!strURI.equals(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidReferer(String referer) {
        if (this.referer_prefixs == null || this.referer_prefixs.length == 0) {
            return true;
        }
        if (referer == null || referer.trim().length() == 0) {
            return false;
        }
        referer = referer.trim();
        for (String s : this.referer_prefixs) {
            if (!referer.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean canVisit(List<KeyValue> vRecords, String ip) {
        if (this.second_limit <= 0 || this.visit_limit <= 0) {
            return true;
        }
        if (vRecords == null) {
            return false;
        }
        KeyValue kv = new KeyValue(System.currentTimeMillis(), ip);
        vRecords.add(0, kv);
        long time = System.currentTimeMillis();
        time -= (long)(this.second_limit * 1000);
        while (vRecords.size() > 0) {
            int end = vRecords.size() - 1;
            kv = vRecords.get(end);
            if (kv == null) {
                vRecords.remove(end);
                continue;
            }
            if ((Long)kv.getKey() >= time) break;
            vRecords.remove(end);
        }
        return vRecords.size() <= this.visit_limit;
    }

    public void destroy() {
    }
}

